/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples.state;

import com.jgoodies.looks.Options;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sf.cuf.fw.AbstractSwingApplication;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.UserProperties;
import net.sf.cuf.ui.SwingDecorator;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class Main
extends AbstractSwingApplication
implements Application {
    private Main() {
    }

    public void doStart(String[] pArgs) {
        super.doStart(pArgs);
        this.loadProperties();
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        System.setProperty("sun.awt.noerasebackground", "true");
        System.setProperty("sun.awt.keepWorkingSetOnMinimize", "true");
        if (System.getProperty("os.name", "unknown").toLowerCase().contains("linux")) {
            System.setProperty("swing.aatext", "true");
        }
        try {
            String defaultLAF = System.getProperty("swing.defaultlaf");
            if (defaultLAF == null) {
                UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
                Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
                defaultLAF = Options.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(defaultLAF);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        SwingDecorator.addBundle((String)"i18n/sortingtable");
        String fileName = "statetest.xml";
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        InputStream input = loader.getResourceAsStream(fileName);
        SwingXMLBuilder builder = SwingXMLBuilder.create((InputStream)input);
        final Dc dc = (Dc)builder.getNonVisualObject("StateDc");
        final HashMap<String, Main> args = new HashMap<String, Main>();
        args.put("Application", this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dc.init(null, args);
            }
        });
    }

    public void doStop() {
        this.saveProperties();
        System.exit(0);
    }

    private void loadProperties() {
        try {
            this.mAppProperties = UserProperties.read(null, null, (String)"statetest_user.properties");
        }
        catch (IOException e) {
            System.err.println("loadProperties problems: " + e);
        }
    }

    private void saveProperties() {
        try {
            UserProperties.write((Properties)this.mAppProperties, null, (String)"statetest_user.properties");
        }
        catch (IOException e) {
            System.err.println("saveProperties problems: " + e);
        }
    }

    public static void main(String[] pArgs) {
        Main app = new Main();
        app.doStart(pArgs);
    }
}

