package net.sf.cuf.examples.model.portal;

import net.sf.cuf.fw2.DialogPc;
import net.sf.cuf.fw2.AbstractDialogPc;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;

import javax.swing.JDialog;
import java.util.Map;
import java.awt.Rectangle;

/**
 * This dialog is an example of a simple modal dialog, it assumes that the
 * dialog was created within a window.
 */
public class AboutPc extends AbstractDialogPc implements DialogPc, SwingXMLBuilder.Backlink
{
    // the builder that created us
    private SwingXMLBuilder mBuilder;

    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    public void init(final Dc pDc, final Map pArgs)
    {
        super.init(pDc, pArgs);
    }

    public Object getVisualPresentation()
    {
        return mBuilder.getComponentByName("Frame/AboutDialog");
    }

    public void dispose(final Map<String, ? super Object> pArgs)
    {
        super.dispose(pArgs);

        JDialog dialog= (JDialog)mBuilder.getContainerByName("Frame/AboutDialog");
        dialog.dispose();
    }

    /**
     * Find the parent frame, and center this modal dialog on top of it.
     */
    void show()
    {
        // calculate size
        JDialog dialog= (JDialog)mBuilder.getContainerByName("Frame/AboutDialog");
        dialog.pack();

        // center dialog with respect to its parent
        Rectangle parentBounds= dialog.getParent().getBounds();

        int deltaX = (parentBounds.width  - dialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - dialog.getBounds().height) / 2;
        dialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);

        // show it!
        dialog.show();
    }

    /**
     * Hide the dialog.
     */
    void hide()
    {
        JDialog dialog= (JDialog)mBuilder.getContainerByName("Frame/AboutDialog");
        dialog.hide();
    }
}
