/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples.model.uc1;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.examples.model.uc1.LoadDataRequest;
import net.sf.cuf.examples.model.uc1.SaveDataRequest;
import net.sf.cuf.examples.model.uc1.UseCase1Pc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.AbstractDialogDc;
import net.sf.cuf.fw2.BlockEvent;
import net.sf.cuf.fw2.DialogDc;
import net.sf.cuf.fw2.ShowStatusEvent;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.state.State;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.xfer.Dispatch;
import net.sf.cuf.xfer.Response;
import net.sf.cuf.xfer.SwingDispatcher;

public class UseCase1Dc
extends AbstractDialogDc
implements DialogDc {
    private SwingXMLBuilder mBuilder;
    private UseCase1Pc mPc;
    private Application mApp;
    private int mDummyDataCounter = 0;
    private Dispatch mDispatcher;

    public void init(Dc pParent, Map<String, ? super Object> pArgs) {
        super.init(pParent, pArgs);
        this.mDispatcher = new SwingDispatcher();
        this.mApp = (Application)pArgs.get("Application");
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("modeltest/uc1.xml");
        HashMap<String, UseCase1Dc> nonVisual = new HashMap<String, UseCase1Dc>();
        nonVisual.put("UseCase1Dc", this);
        nonVisual.put("TableData", (UseCase1Dc)((Object)this.mApp.getAppModel().get("TableData")));
        this.mBuilder = SwingXMLBuilder.create((InputStream)in, nonVisual);
        this.mPc = (UseCase1Pc)((Object)this.mBuilder.getNonVisualObject("UseCase1Pc"));
        this.mPc.init((Dc)this, pArgs);
    }

    public Object getVisualPresentation() {
        return this.mPc.getVisualPresentation();
    }

    public boolean canPassivate() {
        State dataDirty = (State)this.mBuilder.getNonVisualObject("DataDirty");
        return !dataDirty.isEnabled();
    }

    public void doActivate(Map<String, ? super Object> pArgs) {
        System.out.println("UseCase1Dc.doActivate");
        this.mPc.doActivate();
    }

    public void doPassivate(Map<String, ? super Object> pArgs) {
        System.out.println("UseCase1Dc.doPassivate");
        this.mPc.doPassivate();
    }

    public void dispose(Map<String, ? super Object> pArgs) {
        this.mPc.dispose(pArgs);
    }

    public void loadData() {
        BlockEvent block = new BlockEvent((Object)this, true);
        this.postAppEvent((AppEvent)block);
        ShowStatusEvent status = new ShowStatusEvent((Object)this, "Lade Daten, das dauert etwas ...");
        this.postAppEvent((AppEvent)status);
        LoadDataRequest loadDataRequest = new LoadDataRequest(this.mDummyDataCounter);
        loadDataRequest.setDispatchTarget((Object)this, "dataLoaded");
        ++this.mDummyDataCounter;
        this.mDispatcher.asyncDispatchInEDT(loadDataRequest);
    }

    public <T> void dataLoaded(Response<T> pResponse) {
        String statusText;
        if (pResponse.isValid()) {
            ValueModel tableData = (ValueModel)this.mApp.getAppModel().get("TableData");
            tableData.setValue(pResponse.getResult());
            statusText = "Daten geladen";
        } else {
            statusText = "Daten konnten nicht geladen werden!";
        }
        ShowStatusEvent status = new ShowStatusEvent((Object)this, statusText);
        this.postAppEvent((AppEvent)status);
        BlockEvent unblock = new BlockEvent((Object)this, false);
        this.postAppEvent((AppEvent)unblock);
    }

    public void saveData() {
        BlockEvent block = new BlockEvent((Object)this, true);
        this.postAppEvent((AppEvent)block);
        ShowStatusEvent status = new ShowStatusEvent((Object)this, "Speichere Daten, das dauert etwas ...");
        this.postAppEvent((AppEvent)status);
        ValueModel tableData = (ValueModel)this.mApp.getAppModel().get("TableData");
        SaveDataRequest saveDataRequest = new SaveDataRequest((List)tableData.getValue());
        saveDataRequest.setDispatchTarget((Object)this, "dataSaved");
        this.mDispatcher.asyncDispatchInEDT(saveDataRequest);
    }

    public void dataSaved(Response<?> pResponse) {
        String statusText = pResponse.isValid() ? "Daten gespeichert" : "Daten konnten nicht gespeichert werden!";
        ShowStatusEvent status = new ShowStatusEvent((Object)this, statusText);
        this.postAppEvent((AppEvent)status);
        BlockEvent unblock = new BlockEvent((Object)this, false);
        this.postAppEvent((AppEvent)unblock);
    }

    public void monitorVMChange(ChangeEvent pEvent) {
        ValueModel source = (ValueModel)pEvent.getSource();
        System.out.println("(new) index value = " + source.getValue());
    }
}

