/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples;

import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import net.sf.cuf.ui.builder.PopupManager;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class Popup {
    private SwingXMLBuilder mBuilder;

    public void init(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void quit(ActionEvent e) {
        System.out.println("quit");
        System.exit(0);
    }

    public void doHallo(ActionEvent e) {
        System.out.println("popup event:" + e);
        Object source = e.getSource();
        if (source instanceof JComponent) {
            System.out.println("event came from widget " + this.mBuilder.getNameByComponent((JComponent)source));
            JPopupMenu popup = PopupManager.getRootPopup((ActionEvent)e);
            System.out.println("contained in popup: " + this.mBuilder.getNameByComponent((JComponent)popup));
            JComponent trigger = PopupManager.getPopupTrigger((ActionEvent)e);
            System.out.println("trigger: " + this.mBuilder.getNameByComponent(trigger));
        } else {
            System.out.println("event came from object " + source);
        }
    }

    public static void main(String[] args) {
        Popup pk = new Popup();
        HashMap<String, Popup> nonvisual = new HashMap<String, Popup>();
        nonvisual.put("Pk", pk);
        String fileName = "Popup.xml";
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        SwingXMLBuilder builder = SwingXMLBuilder.create((InputStream)input, nonvisual);
        pk.init(builder);
        JFrame tableFrame = (JFrame)builder.getContainerByName("TableFrame");
        tableFrame.pack();
        tableFrame.show();
    }
}

