/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.cuf.ui.DispatcherAction;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class TestPk2 {
    private SwingXMLBuilder mBuilder;
    private int mCounter;

    public void init(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
        this.mCounter = 0;
        this.setCounter();
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("myFrame");
        frame.pack();
        frame.show();
    }

    public void reverse(ActionEvent e) {
        JTextField textField = (JTextField)this.mBuilder.getComponentByName("myFrame/TestPanel/textField");
        String oldText = textField.getText();
        if (!"".equals(oldText)) {
            StringBuilder sb = new StringBuilder(oldText);
            textField.setText(sb.reverse().toString());
            ++this.mCounter;
            this.setCounter();
        }
    }

    public void quit(ActionEvent e) {
        System.out.println("quit");
        System.out.println("real source: " + ((DispatcherAction)e.getSource()).getRealSource());
        System.exit(0);
    }

    public void help(ActionEvent e) {
        System.out.println("help");
    }

    public void about(ActionEvent e) {
        JDialog aboutDialog = (JDialog)this.mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.setModal(true);
        JButton okButton = (JButton)this.mBuilder.getComponentByName("myFrame/aboutDialog/Panel/OK");
        aboutDialog.getRootPane().setDefaultButton(okButton);
        aboutDialog.pack();
        Rectangle parentBounds = aboutDialog.getParent().getBounds();
        System.out.println("parent bounds:" + parentBounds);
        int deltaX = (parentBounds.width - aboutDialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - aboutDialog.getBounds().height) / 2;
        aboutDialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);
        aboutDialog.show();
        System.out.println("after aboutDialog.show()");
    }

    public void aboutOk(ActionEvent e) {
        JDialog aboutDialog = (JDialog)this.mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.hide();
        System.out.println("about was OK!");
    }

    public void aboutCancel(ActionEvent e) {
        JDialog aboutDialog = (JDialog)this.mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.hide();
        System.out.println("about was CANCELED!");
    }

    private void setCounter() {
        JLabel usageCounter = (JLabel)this.mBuilder.getComponentByName("myFrame/TestPanel/usageCounter");
        usageCounter.setText(Integer.toString(this.mCounter));
    }

    public static void main(String[] args) {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("TestPk2.xml");
        boolean createWithExternalNonVisual = true;
        if (createWithExternalNonVisual) {
            TestPk2 pk = new TestPk2();
            HashMap<String, TestPk2> nonvisual = new HashMap<String, TestPk2>();
            nonvisual.put("Pk", pk);
            SwingXMLBuilder builder = SwingXMLBuilder.create((InputStream)input, nonvisual);
            pk.init(builder);
        } else {
            SwingXMLBuilder builder = SwingXMLBuilder.create((InputStream)input);
            TestPk2 pk = (TestPk2)builder.getNonVisualObject("Pk");
            pk.init(builder);
        }
    }
}

