package net.sf.cuf.examples;

import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.ui.DispatcherAction;

import javax.swing.JFrame;
import javax.swing.JDialog;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.ListSelectionEvent;
import java.awt.event.ActionEvent;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Dimension;
import java.awt.Point;
import java.io.InputStream;

/**
 * small sample presentation component to demonstate the use
 * of SwingXMLBuilder
 */
public class Split implements SwingXMLBuilder.Backlink
{
    // our mapping helper
    private SwingXMLBuilder mBuilder;

    /**
     * The constructor does nothing.
     */
    public Split()
    {
    }

    /**
     * Called by the builder, we remember the builder to access widgets
     * later on.
     * @param pBuilder SwingXMLBuilder that creates all objects (including ourself)
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method initializes everything.
     */
    public void init()
    {
        // change the tree selection mode
        JTree tree= (JTree) mBuilder.getComponentByName("myFrame/SplitPane/NavigationScrollPane/Tree");
        tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);

        // put some data in the table
        JTable table= (JTable) mBuilder.getComponentByName("myFrame/SplitPane/ContentPanel/TableScrollPane/Table");
        DefaultTableModel model= new DefaultTableModel(new Object[][]{{"Hallo", "Welt"},{"Wie", "gehts?"}}, new Object[]{"Spalte1", "Spalte2"});
        table.setModel(model);

        // make the frame visible
        JFrame frame= (JFrame)mBuilder.getContainerByName("myFrame");
        frame.pack();
        frame.show();
    }

    /**
     * Exit program
     * @param e event of the action
     */
    public void quit(final ActionEvent e)
    {
        System.out.println("quit");
        System.out.println("real source: "+((DispatcherAction)e.getSource()).getRealSource());
        System.exit(0);
    }

    /**
     * Print something on stdout.
     * @param e not used
     */
    public void help(final ActionEvent e)
    {
        System.out.println("help");
    }

    /**
     * Callback method from the navigation tree
     * @param e selection event
     */
    public void navSelection(final TreeSelectionEvent e)
    {
        System.out.println("navigation changed:"+e);
        System.out.println("    old lead: "+e.getOldLeadSelectionPath());
        System.out.println("    new lead: "+e.getNewLeadSelectionPath());
        TreePath[] paths= e.getPaths();
        for (int i = 0; i < paths.length; i++)
        {
            TreePath path = paths[i];
            if (e.isAddedPath(i))
            {
                System.out.println("    path add: "+path);
            }
            else
            {
                System.out.println("    path removed: "+path);
            }
        }
    }

    /**
     * Callback method from the table
     * @param e selection event
     */
    public void tableSelection(final ListSelectionEvent e)
    {
        System.out.println("Table selection changed: "+e);
    }

    /**
     * Show an about dialog.
     * @param e not used
     */
    public void about(final ActionEvent e)
    {
        // we want a modal dialog
        JDialog aboutDialog= (JDialog) mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.setModal(true);

        // set a default button
        JButton okButton= (JButton) mBuilder.getComponentByName("myFrame/aboutDialog/Panel/OK");
        aboutDialog.getRootPane().setDefaultButton(okButton);

        // calculate size
        aboutDialog.pack();

        // center dialog with respect to its parent
        Rectangle parentBounds= aboutDialog.getParent().getBounds();
        if (false)
        {
            // alternative centering with respect to the screen
            Dimension screenSize= Toolkit.getDefaultToolkit().getScreenSize();
            parentBounds= new Rectangle(new Point(0,0), screenSize);
        }
        System.out.println("parent bounds:"+parentBounds);
        int deltaX = (parentBounds.width  - aboutDialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - aboutDialog.getBounds().height) / 2;
        aboutDialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);

        // make dialog visible
        aboutDialog.show();
        System.out.println("after aboutDialog.show()");
    }

    /**
     * Act on "OK" in the about dialog.
     * @param e not used
     */
    public void aboutOk(final ActionEvent e)
    {
        JDialog aboutDialog= (JDialog) mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.hide();
        System.out.println("about was OK!");
    }

    /**
     * Act on "ESCAPE" or "CANCEL" in the about dialog.
     * @param e not used
     */
    public void aboutCancel(final ActionEvent e)
    {
        JDialog aboutDialog= (JDialog) mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.hide();
        System.out.println("about was CANCELED!");
    }

    /**
     * Starts the app.
     * Try -Dswing.defaultlaf=com.sun.java.swing.plaf.windows.WindowsLookAndFeel on the command line.
     *
     * @param args not used
     */
    public static void main(final String[] args)
    {
        InputStream     input  = Thread.currentThread().getContextClassLoader().getResourceAsStream("Split.xml");
        SwingXMLBuilder builder= SwingXMLBuilder.create(input);
        Split           pk     = (Split)builder.getNonVisualObject("Pk");
        pk.init();

    }
}
