package net.sf.cuf.examples;

import net.sf.cuf.ui.SwingDecorator;
import net.sf.cuf.ui.SwingMapping;
import net.sf.cuf.ui.SwingConnectionManager;
import net.sf.cuf.examples.TestPanel;

import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JComponent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionEvent;

/**
 * small sample presentation component to demonstate the use
 * of SwingMapping and SwingConnectionManager.
 */
public class TestPk
{
    // our mapping helper
    private SwingMapping mMapping;

    // number of calls of our business method
    private int          mCounter;

    /**
     * The constructor initializes everything.
     */
    public TestPk()
    {
        // register our property file
        SwingDecorator.addBundle("i18n/test");

        // create our panel
        JComponent  panel= new TestPanel();

        // generate a mapping for it
        mMapping= SwingMapping.createMapping(panel);

        // connect our callback handler to the button and the textfield
        JButton    button   = (JButton)    mMapping.getComponentByName("TestPanel/button");
        JTextField textField= (JTextField) mMapping.getComponentByName("TestPanel/textField");
        SwingConnectionManager.createActionConnection(button,    this, "reverse");
        SwingConnectionManager.createActionConnection(textField, this, "reverse");

        // set counter
        mCounter= 0;
        setCounter();

        // generate a frame for the panel and make it visible
        JFrame frame= new JFrame();
        SwingDecorator.initialize(frame, "myFrame");
        frame.getContentPane().add(panel);
        frame.addWindowListener(new WindowAdapter()
        {
            public void windowClosing(final WindowEvent e)
            {
                System.exit(0);
            }
        });
        frame.pack();
        frame.show();
    }

    /**
     * Our "business" method that is called from both the button and the
     * textfield. It takes any non-empty text from the text field, reverses
     * it an stores it back in the text field
     *
     * @param e not used
     */
    public void reverse(final ActionEvent e)
    {
        JTextField textField= (JTextField) mMapping.getComponentByName("TestPanel/textField");
        String     oldText  = textField.getText();
        if (!"".equals(oldText))
        {
            StringBuilder sb = new StringBuilder(oldText);
            textField.setText(sb.reverse().toString());

            mCounter++;
            setCounter();
        }
    }

    /**
     * Small helper method to update the counter in the UI.
     */
    private void setCounter()
    {
        JLabel usageCounter= (JLabel) mMapping.getComponentByName("TestPanel/usageCounter");
        usageCounter.setText(Integer.toString(mCounter));
    }

    /**
     * Starts the panel standalone to quickly test layout issues.
     *
     * @param args not used
     */
    public static void main(final String[] args)
    {
        new TestPk();
    }
}
