package net.sf.cuf.examples.model.portal;

import javax.swing.border.Border;
import javax.swing.border.AbstractBorder;
import javax.swing.ButtonModel;
import javax.swing.AbstractButton;
import java.awt.Insets;
import java.awt.Component;
import java.awt.Graphics;

/**
 * This border can be used as a decorator for buttons.
 * It adds a "cross hair feeling" to a button.
 */
public class CrossHairBorder extends AbstractBorder implements Border
{
    private static final Insets INSETS = new Insets(3, 3, 3, 3);
    private static final int    LENGTH = 14;

    /**
     * TODO translate
     * Hier werden die Abst�nde zur�ckgeliefert, die f�r die Border ben�tigt werden.
     * Diese h�ngen davon ab, ob die Toolbar horizontal oder vertikal ist, da dem-
     * entsprechend die Grifffl�che oben oder unten ist.
     *
     * @param c Die Komponente, f�r die INSETS bestimmt werden sollen.
     * @return Insets Die Abst�nde zu allen Seiten, die die Border ben�tigt.
     */
    public Insets getBorderInsets(final Component c)
    {
        return INSETS;
    }

    /**
     * TODO translate
     * Die Border wird auf den Schirm gemalt.
     *
     * @param c Die Componente, die eine Border braucht.
     * @param g Das Graphics-Object, auf dem gemalt wird.
     * @param x Die X-Position
     * @param y Die Y-Position
     * @param w Die Breite
     * @param h Die H�he
     */
    public void paintBorder(final Component c, final Graphics g, final int x, final int y, final int w, final int h)
    {
        if (!(c instanceof AbstractButton))
        {
            return;
        }

        ButtonModel model = ((AbstractButton) c).getModel();
        if (model.isSelected())
        {
            g.translate(x, y);
            g.setColor(ColorFactory.getControlDarkShadow());
            g.drawLine(0, 0, LENGTH - 1, 0);
            g.drawLine(0, 1, 0, LENGTH - 1);
            //
            g.drawLine(w - LENGTH, 0, w - 1, 0);
            g.drawLine(w - LENGTH, 1, w - LENGTH, 2);
            g.drawLine(w - 3, 3, w - 3, LENGTH - 1);
            //
            g.drawLine(1, h - LENGTH, 2, h - LENGTH);
            g.drawLine(0, h - LENGTH, 0, h - 1);
            g.drawLine(3, h - 3, LENGTH - 1, h - 3);
            //
            g.drawLine(w - 2, h - LENGTH, w - 1, h - LENGTH);
            g.drawLine(w - 3, h - LENGTH, w - 3, h - 4);
            g.drawLine(w - LENGTH, h - 3, w - 3, h - 3);
            g.drawLine(w - LENGTH, h - 2, w - LENGTH, h - 1);
            //
            g.setColor(ColorFactory.getControl());
            g.drawLine(LENGTH - 1, 1, LENGTH - 1, 2);
            g.drawLine(2, 2, LENGTH - 2, 2);
            g.drawLine(2, 3, 2, LENGTH - 2);
            g.drawLine(1, LENGTH - 1, 2, LENGTH - 1);
            //
            g.drawLine(w - LENGTH + 1, 2, w - 3, 2);
            g.drawLine(w - 1, 1, w - 1, LENGTH - 2);
            g.drawLine(w - 2, LENGTH - 1, w - 1, LENGTH - 1);
            //
            g.drawLine(2, h - LENGTH + 1, 2, h - 3);
            g.drawLine(1, h - 1, LENGTH - 2, h - 1);
            g.drawLine(LENGTH - 1, h - 2, LENGTH - 1, h - 1);
            //
            g.drawLine(w - 1, h - LENGTH + 1, w - 1, h - 1);
            g.drawLine(w - LENGTH + 1, h - 1, w - 2, h - 1);
            g.translate(-x, -y);
        }
    }
}
