/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples.model;

import com.jgoodies.looks.Options;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.AbstractDialogSwingApplication;
import net.sf.cuf.fw2.DialogApplication;
import net.sf.cuf.fw2.DialogDescription;
import net.sf.cuf.fw2.DialogManager;
import net.sf.cuf.fw2.OpenDialogEvent;
import net.sf.cuf.fw2.UserProperties;
import net.sf.cuf.model.ValueHolder;
import net.sf.cuf.ui.SwingDecorator;

public class Main
extends AbstractDialogSwingApplication
implements DialogApplication,
DialogManager.DialogCallback {
    public void doStart(String[] pArgs) {
        super.doStart(pArgs);
        this.loadProperties();
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        System.setProperty("sun.awt.noerasebackground", "true");
        System.setProperty("sun.awt.keepWorkingSetOnMinimize", "true");
        if (System.getProperty("os.name", "unknown").toLowerCase().contains("linux")) {
            System.setProperty("swing.aatext", "true");
        }
        try {
            String defaultLAF = System.getProperty("swing.defaultlaf");
            if (defaultLAF == null) {
                UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
                Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
                defaultLAF = Options.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(defaultLAF);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        SwingDecorator.addBundle((String)"i18n/sortingtable");
        ValueHolder tableListHolder = new ValueHolder();
        tableListHolder.setValue(new ArrayList());
        this.getAppModel().put("TableData", tableListHolder);
        Map knownDialogs = DialogDescription.loadKnownDialogs((String)"modeltest/appdialog.properties");
        this.mDialogManager.setKnownDialogs(knownDialogs);
        this.mDialogManager.setCallback((DialogManager.DialogCallback)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpenDialogEvent openDialogEvent = new OpenDialogEvent((Object)this, "AppDc");
                Main.this.postAppEvent((AppEvent)openDialogEvent);
            }
        });
    }

    public void dialogOpened(Dc pDc, Map pArgs) {
    }

    public void dialogClosed(Dc pDc, boolean pWasClosed, Map pArgs) {
        if (this.mDialogManager.getActiveDialogs().isEmpty()) {
            System.out.println("no active dialogs left, will stop");
            this.doStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        try {
            this.saveProperties();
        }
        finally {
            System.exit(0);
        }
    }

    private void loadProperties() {
        try {
            this.mAppProperties = UserProperties.read(null, null, (String)"modeltest_user.properties");
        }
        catch (IOException e) {
            System.err.println("loadProperties problems: " + e);
        }
    }

    private void saveProperties() {
        try {
            UserProperties.write((Properties)this.mAppProperties, null, (String)"modeltest_user.properties");
        }
        catch (IOException e) {
            System.err.println("saveProperties problems: " + e);
        }
    }

    public static void main(String[] pArgs) {
        Main app = new Main();
        app.doStart(pArgs);
    }
}

