package net.sf.cuf.examples.state;

import net.sf.cuf.fw.Pc;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.state.ui.SwingDocumentState;
import net.sf.cuf.state.ui.SwingEnabledAdapter;
import net.sf.cuf.state.ui.SwingSelectedState;
import net.sf.cuf.state.ui.SwingJTableEnabledAdapter;
import net.sf.cuf.state.ui.SwingListSelectionState;
import net.sf.cuf.state.State;
import net.sf.cuf.state.StateAdapter;
import net.sf.cuf.examples.model.AppData;

import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JCheckBox;
import javax.swing.table.DefaultTableModel;
import java.util.Map;
import java.awt.event.ActionEvent;

/**
 * Presentation component of the State/Stateadapter example application.
 * The interesting stuff is mainly in the init() and changeDefault()
 * method.
 */
public class StatePc implements Pc, SwingXMLBuilder.Backlink
{
    /** the builder that created us */
    private SwingXMLBuilder     mBuilder;
    /** our peer dialog component */
    private StateDc             mDc;
    /** our application */
    private Application         mApp;
    /** State watching our text field */
    private SwingDocumentState   mDocumentState;

    /**
     * Callback method for the Builder.
     * @param pBuilder the builder that created us
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method is called by the dialog controller peer during
     * the initialisation phase of an application.<br/>
     * All arguments are handed in with a map object, that map always
     * contains the application object with the key
     * <code>Application.APPLICATION_KEY</code>.
     * The map should <b>not</b> be altered inside the method.
     *
     * @param pDc our peer dialog controller, never null.
     * @param pArgs variable argument list modeled as a key/value map,
     *              never null.
     */
    public void init(final Dc pDc, final Map<String, ? super Object> pArgs)
    {
        mDc = (StateDc)pDc;
        mApp= (Application)  pArgs.get(Application.APPLICATION_KEY);

        // put some data in the table
        JTable table= (JTable)mBuilder.getComponentByName("Frame/Panel/ScrollPane/Table");
        DefaultTableModel model= new DefaultTableModel(new Object[][]{{"Hans", "Mainer"},
                                                                      {"Erika", "Mustermann"}},
                                                       new Object[]{"Vorname", "Name"});
        table.setModel(model);

        /*
         * connect States and StateAdapters
         */
        // init the default text
        JTextField textfield   = (JTextField)mBuilder.getComponentByName("Frame/Panel/TextField");
        JLabel     defaultLabel= (JLabel)mBuilder.getComponentByName("Frame/Panel/Default");
        String     defaultText = "match";
        textfield.   setText(defaultText);
        defaultLabel.setText(defaultText);

        // connect the table enabling to the non-modification of the textfield
        mDocumentState= new SwingDocumentState(textfield, defaultText);
        StateAdapter textfieldMatchAdapter= new SwingJTableEnabledAdapter(mDocumentState);
        textfieldMatchAdapter.add(table);

        // connect the enabling/disabling of the checkbox to the selection / no selection of the table
        JCheckBox    checkbox             = (JCheckBox)mBuilder.getComponentByName("Frame/Panel/CheckBox");
        State        tableSelectionState  = new SwingListSelectionState(table);
        StateAdapter tableSelectionAdapter= new SwingEnabledAdapter(tableSelectionState);
        tableSelectionAdapter.add(checkbox, true);

        // connect the enabling/disabling of the textfield to the state of the checkbox
        State        checkboxState  = new SwingSelectedState(checkbox.getModel());
        StateAdapter checkboxAdapter= new SwingEnabledAdapter(checkboxState);
        checkboxAdapter.add(textfield);

        /*
         * show UI on screen (make the frame visible)
         */
        JFrame frame= (JFrame)mBuilder.getContainerByName("Frame");
        int x       = Integer.parseInt(AppData.DEFAULT_X);
        int y       = Integer.parseInt(AppData.DEFAULT_Y);
        int width   = Integer.parseInt(AppData.DEFAULT_WIDTH);
        int height  = Integer.parseInt(AppData.DEFAULT_WIDTH);
        try
        {
            x     = Integer.parseInt(mApp.getProperty(AppData.DEFAULT_X_KEY,      AppData.DEFAULT_X));
            y     = Integer.parseInt(mApp.getProperty(AppData.DEFAULT_Y_KEY,      AppData.DEFAULT_Y));
            width = Integer.parseInt(mApp.getProperty(AppData.DEFAULT_WIDTH_KEY,  AppData.DEFAULT_WIDTH ));
            height= Integer.parseInt(mApp.getProperty(AppData.DEFAULT_HEIGHT_KEY, AppData.DEFAULT_HEIGHT));
        }
        catch (NumberFormatException ignored)
        {
        }
        frame.setLocation(x, y);
        frame.setSize    (width, height);
        frame.show       ();
    }

    /**
     * Handle the user callback when he wants to quit the application.
     * @param pEvent not used
     */
    public void quit(final ActionEvent pEvent)
    {
        // save current size etc.
        JFrame frame = (JFrame)mBuilder.getContainerByName("Frame");
        int    width = frame.getWidth();
        int    height= frame.getHeight();
        int    x     = frame.getX();
        int    y     = frame.getY();
        mApp.setProperty(AppData.DEFAULT_X_KEY,      Integer.toString(x));
        mApp.setProperty(AppData.DEFAULT_Y_KEY,      Integer.toString(y));
        mApp.setProperty(AppData.DEFAULT_WIDTH_KEY,  Integer.toString(width));
        mApp.setProperty(AppData.DEFAULT_HEIGHT_KEY, Integer.toString(height));

        mDc.quit();
    }

    /**
     * Handle the user callback when he wants to change the default text.
     * @param pEvent not used
     */
    public void changeDefault(final ActionEvent pEvent)
    {
        JLabel     defaultLabel  = (JLabel)mBuilder.getComponentByName("Frame/Panel/Default");
        JTextField textfield     = (JTextField)mBuilder.getComponentByName("Frame/Panel/TextField");
        String     newDefaultText= textfield.getText();

        defaultLabel.setText(newDefaultText);
        mDocumentState.setCompareContent(newDefaultText);
    }
}
