package net.sf.cuf.examples.state;

import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

import java.util.Map;

/**
 * Dialog component of the State/Stateadapter example application.
 * Most of the interesting stuff is in the init() method of the StatePc class.
 */
public class StateDc implements Dc, SwingXMLBuilder.Backlink
{
    /** the builder that created us */
    private SwingXMLBuilder mBuilder;
    /** our peer dialog component */
    private StatePc mPc;
    /** our application */
    private Application     mApp;

    /**
     * Callback method for the Builder.
     * @param pBuilder the builder that created us
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method is called by Main in the EDT.
     *
     * @param pParent null
     * @param pArgs variable argument list modeled as a key/value map, never null.
     */
    public void init(final Dc pParent, final Map<String, ? super Object> pArgs)
    {
        mPc = (StatePc)mBuilder.getNonVisualObject("StatePc");
        mApp= (Application)  pArgs.get(Application.APPLICATION_KEY);

        // now initialize our Pc
        mPc.init(this, pArgs);

   }

    /**
     * Used by our presentation component to stop the app.
     */
    void quit()
    {
        mApp.doStop();
    }
}
