package net.sf.cuf.examples.model.uc4;

import net.sf.cuf.fw2.DialogDc;
import net.sf.cuf.fw2.AbstractDialogDc;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.ValueHolder;
import net.sf.cuf.examples.model.AppData;

import java.io.InputStream;
import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;

/**
 * UseCase4Dc is the dialog component of a very simple dialog.
 * It is used as the base for a "fill in" exercise.
 */
public class UseCase4Dc extends AbstractDialogDc implements DialogDc
{
    /** our presentation peer */
    private UseCase4Pc      mPc;

    /** the builder that created our Pc and UI */
    private SwingXMLBuilder mBuilder;

    /** the value model containing our dialogs data (a List with Date entries) */
    private ValueModel      mDates;

    /**
     * This method is called by the parent dialog controller during
     * the initialisation phase of an application.<br/>
     *
     * @param pParent our parent must implement AppEventSupport
     * @param pArgs variable argument list modeled as a key/value map, never null.
     */
    public void init(final Dc pParent, final Map<String, ? super Object> pArgs)
    {
        Map myArgs= new HashMap(pArgs);
        super.init(pParent, myArgs);

        // init the dates value model
        mDates= new ValueHolder(new ArrayList());

        // load our Pc and its UI
        InputStream in= Thread.currentThread().getContextClassLoader().getResourceAsStream(AppData.XML_APP_UC4_NAME);
        Map         nonVisual= new HashMap();
        nonVisual.put("UseCase4Dc", this);
        nonVisual.put("DatesVM", mDates);
        mBuilder= SwingXMLBuilder.create(in, nonVisual);
        mPc= (UseCase4Pc)mBuilder.getNonVisualObject("UseCase4Pc");

        mPc.init(this, myArgs);
    }

    /**
     * Called from the dialog coordinator to tell the dialog to switch
     * to the active state.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void doActivate(final Map<String, ? super Object> pArgs)
    {
        System.out.println("UseCase4Dc.doActivate");
    }

    /**
     * We can always be passivated.
     * @return always true
     */
    public boolean canPassivate()
    {
        return true;
    }

    /**
     * Called from the dialog coordinator to tell the dialog to switch
     * to the passive state.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void doPassivate(final Map<String, ? super Object> pArgs)
    {
        System.out.println("UseCase4Dc.doPassivate");

        // we forget all dates when we are passivated
        mDates.setValue(new ArrayList());
    }

    /**
     * Called from the dialog coordinator to tell the dialog to cleanup all
     * resources. We only call dispose of our Pc.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void dispose(final Map<String, ? super Object> pArgs)
    {
        mPc.dispose(pArgs);
    }

    /**
     * Called from the dialog coordinater in the initialized, active or passive
     * state to get the visual representation for this dialog.
     * @return an object that represents the visual representation of this dialog
     */
    public Object getVisualPresentation()
    {
        return mPc.getVisualPresentation();
    }
}
