package net.sf.cuf.examples.model.uc3;

import net.sf.cuf.fw2.DialogPc;
import net.sf.cuf.fw2.AbstractDialogPc;
import net.sf.cuf.fw2.CloseDialogEvent;
import net.sf.cuf.fw2.DialogDc;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;

import javax.swing.JTextField;
import javax.swing.JDialog;
import java.util.Map;
import java.awt.Rectangle;
import java.awt.Container;
import java.awt.GraphicsEnvironment;

/**
 * This dialog is an example of a simple modal dialog.
 */
public class ModalPc extends AbstractDialogPc implements DialogPc, SwingXMLBuilder.Backlink
{
    /** the builder that created us */
    private SwingXMLBuilder mBuilder;
    /** our dialog peer */
    private ModalDc         mDc;
    /** null or the parent of our Dc */
    private DialogDc        mParentDc;

    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    @Override
    public void init(final Dc pDc, final Map<String, ? super Object> pArgs)
    {
        super.init(pDc, pArgs);
        mDc= (ModalDc)pDc;

        // check if the parent has a visual presentation
        if (pArgs.get(ModalDc.PARENT_KEY) instanceof DialogDc)
        {
            mParentDc= (DialogDc)pArgs.get(ModalDc.PARENT_KEY);
        }
    }

    public Object getVisualPresentation()
    {
        return mBuilder.getComponentByName("Dialog");
    }

    @Override
    public void dispose(final Map<String, ? super Object> pArgs)
    {
        super.dispose(pArgs);

        JDialog dialog= (JDialog)mBuilder.getContainerByName("Dialog");
        dialog.dispose();
    }


    /**
     * Find the parent frame, and center this modal dialog on top of it.
     */
    void show()
    {
        JDialog dialog= (JDialog)mBuilder.getContainerByName("Dialog");

        // set text to nothing
        JTextField inputTF= (JTextField)mBuilder.get("Dialog/Panel/Text");
        inputTF.setText("");

        // calculate size
        dialog.pack();

        // center dialog with respect to its parent, if there is no parent, center around the screen
        Container parent= null;
        if (mParentDc!=null)
        {
            Object visual= mParentDc.getVisualPresentation();
            if (visual instanceof Container)
            {
                parent= (Container)visual;
                while (parent.getParent() != null)
                {
                    parent= parent.getParent();
                }
            }
        }

        Rectangle parentBounds;
        if (parent==null)
        {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            parentBounds= ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        }
        else
        {
            parentBounds= parent.getBounds();
        }
        int deltaX = (parentBounds.width  - dialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - dialog.getBounds().height) / 2;
        dialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);

        // show it!
        dialog.show();
    }

    /**
     * Hide the dialog.
     */
    void hide()
    {
        JDialog dialog= (JDialog)mBuilder.getContainerByName("Dialog");
        dialog.hide();
    }

    /**
     * Callback method from the ok button.
     */
    public void ok()
    {
        JTextField inputTF= (JTextField)mBuilder.get("Dialog/Panel/Text");
        String input= inputTF.getText();
        mDc.setResult(input);
        close();
    }

    /**
     * Callback from the cancel button or ESC.
     */
    public void cancel()
    {
        mDc.setResult(null);
        close();
    }

    /**
     * Common close code, close the dialog via a CloseDialogEvent(), this
     * will trigger a call to hide().
     */
    private void close()
    {
        CloseDialogEvent close= new CloseDialogEvent(this, mDc);
        postAppEvent(close);
    }
}
