package net.sf.cuf.examples.model.uc3;

import net.sf.cuf.fw2.AbstractDialogDc;
import net.sf.cuf.fw2.DialogDc;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.examples.model.AppData;

import java.util.Map;
import java.util.HashMap;
import java.io.InputStream;

/**
 * This dialog is an example of a simple modal dialog.
 */
public class ModalDc extends AbstractDialogDc implements DialogDc
{
    /** Key for the result argument. */
    public static final String RESULT_KEY= "result";

    /** Key for the parent argument. */
    static final String PARENT_KEY= "parent";

    // the builder that created our Pc and UI
    private SwingXMLBuilder mBuilder;
    // our presentation peer
    private ModalPc         mPc;
    // null or the result of the modal dialog
    private String          mResult;


    public void init(final Dc pParent, final Map<String, ? super Object> pArgs)
    {
        super.init(pParent, pArgs);

        // load our Pc and its UI
        InputStream in= Thread.currentThread().getContextClassLoader().getResourceAsStream(AppData.XML_APP_MODAL_NAME);
        Map         nonVisual= new HashMap();
        nonVisual.put("ModalDc", this);
        mBuilder= SwingXMLBuilder.create(in, nonVisual);
        mPc= (ModalPc)mBuilder.getNonVisualObject("ModalPc");
        Map args= new HashMap(pArgs);
        args.put(PARENT_KEY, pParent);
        mPc.init(this, args);

    }

    public void doActivate(final Map<String, ? super Object> pArgs)
    {
        // reset result
        mResult= null;

        mPc.show();

    }

    public void doPassivate(final Map<String, ? super Object> pArgs)
    {
        // check if the user entered something and confirmed with OK
        if (mResult!=null)
        {
            pArgs.put(RESULT_KEY, mResult);
        }
        mPc.hide();
    }

    public void dispose(final Map<String, ? super Object> pArgs)
    {
        mPc.dispose(pArgs);
    }

    public Object getVisualPresentation()
    {
        return mPc.getVisualPresentation();
    }

    /**
     * Called by our presentation peer to set the result
     * @param pResult the result
     */
    void setResult(final String pResult)
    {
        mResult= pResult;
    }
}
