package net.sf.cuf.examples.model.uc2;

import net.sf.cuf.fw2.DialogPc;
import net.sf.cuf.fw2.AbstractDialogPc;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.ui.AutoCompletion;
import net.sf.cuf.model.ValueModel;

import javax.swing.JComboBox;
import java.util.Map;
import java.util.List;
import java.util.Arrays;

/**
 * UseCase2Pc is the presentation component of a very simple dialog.
 * It demonstrates the "can passivate" mechanism.
 */
public class UseCase2Pc extends AbstractDialogPc implements DialogPc, SwingXMLBuilder.Backlink
{
    /** the builder that created us */
    private SwingXMLBuilder mBuilder;

    /**
     * Callback method for the Builder.
     * @param pBuilder the builder that created that object
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method is called by the dialog controller peer during
     * the initialisation phase of an application.<br/>
     *
     * @param pDc our peer dialog controller, must implement AppEventSupport
     * @param pArgs variable argument list modeled as a key/value map,
     *              never null.
     */
    @Override
    public void init(final Dc pDc, final Map<String, ? super Object> pArgs)
    {
        super.init(pDc, pArgs);
        String[] keys    = {"01",       "02",     "44",   "3",        "77",      "05",    "88"};
        String[] displays= {"München", "Hamburg", "Wien", "Budapest", "Breslau", "Paris", "London"};
        ValueModel lofsHolder= (ValueModel)mBuilder.getNonVisualObject("LOVSHolder");
        lofsHolder.setValue(new List[]{Arrays.asList(keys), Arrays.asList(displays)});
        JComboBox combo= (JComboBox) mBuilder.getByShortName("DisplayComboBox");
        combo.setEditable(true);
        new AutoCompletion(combo);
    }

    /**
     * Called from the DialogDc peer in the initialized, active or passive
     * state to get the visual representation for this dialog.
     * @return an object that represents the visual representation of this dialog
     */
    public Object getVisualPresentation()
    {
        return mBuilder.getComponentByName("UC2");
    }
}
