package net.sf.cuf.examples.model.uc1;

import java.io.Serializable;
import java.util.Date;

/**
 * Small "dump" JavaBean-like transport container for data with a copy constructor.
 */
public class UserData implements Serializable
{
    private String  mFirstName;
    private String  mLastName;
    private String  mMiddleName;
    private Date    mBorn;

    public UserData()
    {
        this("", "", "", new Date());
    }

    public UserData(final String pFirstName, final String pLastName, final String pMiddleName, final Date pBorn)
    {
        mFirstName = pFirstName;
        mLastName  = pLastName;
        mMiddleName= pMiddleName;
        mBorn       = pBorn;
    }

    public UserData(final UserData pData)
    {
        mFirstName = pData.getFirstName();
        mLastName  = pData.getLastName();
        mMiddleName= pData.getMiddleName();
        mBorn       = pData.getBorn();
    }


    public String getFirstName()
    {
        return mFirstName;
    }

    public void setFirstName(final String pFirstName)
    {
        mFirstName = pFirstName;
    }

    public String getLastName()
    {
        return mLastName;
    }

    public void setLastName(final String pLastName)
    {
        mLastName = pLastName;
    }

    public String getMiddleName()
    {
        return mMiddleName;
    }

    public void setMiddleName(final String pMiddleName)
    {
        mMiddleName = pMiddleName;
    }

    public Date getBorn()
    {
        return mBorn;
    }

    public void setBorn(final Date pBorn)
    {
        mBorn = pBorn;
    }

    public String getDisplay()
    {
        StringBuilder sb = new StringBuilder();
        sb.append(mFirstName).append(',');
        sb.append(mMiddleName).append(',');
        sb.append(mLastName).append(',');
        sb.append(mBorn);

        return sb.toString();
    }

    public boolean equals(final Object o)
    {
        if (this == o) return true;
        if (!(o instanceof UserData)) return false;

        final UserData userData = (UserData) o;

        if (mBorn != null ? !mBorn.equals(userData.mBorn) : userData.mBorn != null) return false;
        if (mFirstName != null ? !mFirstName.equals(userData.mFirstName) : userData.mFirstName != null) return false;
        if (mLastName != null ? !mLastName.equals(userData.mLastName) : userData.mLastName != null) return false;
        if (mMiddleName != null ? !mMiddleName.equals(userData.mMiddleName) : userData.mMiddleName != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (mFirstName != null ? mFirstName.hashCode() : 0);
        result = 29 * result + (mLastName != null ? mLastName.hashCode() : 0);
        result = 29 * result + (mMiddleName != null ? mMiddleName.hashCode() : 0);
        result = 29 * result + (mBorn != null ? mBorn.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        return new StringBuffer("UserData{")
                .append("FirstName='").append(mFirstName).append('\'')
                .append("; LastName='").append(mLastName).append('\'')
                .append("; MiddleName='").append(mMiddleName).append('\'')
                .append("; Born=").append(mBorn)
                .append('}').append(super.toString()).toString();
    }
}
