package net.sf.cuf.examples.model.multi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import net.sf.cuf.model.ExternalUpdate;
import net.sf.cuf.model.MultiSelectionInList;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.AbstractDialogPc;
import net.sf.cuf.fw2.DialogPc;

/**
 * MultiSelectPc is the presentation component of a dialog.
 * It demonstrates the multiple selection.
 */
public class MultiSelectPc extends AbstractDialogPc implements DialogPc, SwingXMLBuilder.Backlink
{
    /** the builder that created us */
    private SwingXMLBuilder mBuilder;

    /**
     * Callback method for the Builder.
     * @param pBuilder the builder that created that object
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method is called by the dialog controller peer during
     * the initialisation phase of an application.<br/>
     *
     * @param pDc our peer dialog controller, must implement AppEventSupport
     * @param pArgs variable argument list modeled as a key/value map,
     *              never null.
     */
    @Override
    public void init(final Dc pDc, final Map<String, ? super Object> pArgs)
    {
        super.init(pDc, pArgs);
        getLeftListVM().setValue( new ArrayList( Arrays.asList("München", "Hamburg", "Wien", "Budapest", "Breslau", "Paris", "London")));
        getRightListVM().setValue( new ArrayList());
    }

    /**
     * Called from the DialogDc peer in the initialized, active or passive
     * state to get the visual representation for this dialog.
     * @return an object that represents the visual representation of this dialog
     */
    public Object getVisualPresentation()
    {
        return mBuilder.getComponentByName("MultiSelectPanel");
    }
    
    /**
     * Moves the selected elements from the left list to the right list.
     */
    public void moveSelectedRight()
    {
        List selectedElements = new ArrayList( (List)getLeftMultiSIL().getSelectedValuesHolder().getValue());
        ((List)getRightListVM().getValue()).addAll( selectedElements);
        ((List)getLeftListVM().getValue()).removeAll( selectedElements);
        ((ExternalUpdate) getLeftListVM()).signalExternalUpdate();
        ((ExternalUpdate) getRightListVM()).signalExternalUpdate();
        getRightMultiSIL().setSelectedElements( selectedElements);
    }

    /**
     * Moves all elements from the left list to the right list.
     */
    public void moveAllRight()
    {
        List values = new ArrayList( (List)getLeftListVM().getValue());
        ((List)getRightListVM().getValue()).addAll( values);
        ((List)getLeftListVM().getValue()).clear();
        ((ExternalUpdate) getLeftListVM()).signalExternalUpdate();
        ((ExternalUpdate) getRightListVM()).signalExternalUpdate();
        getRightMultiSIL().setSelectedElements( values);
    }

    /**
     * Moves the selected elements from the right list to the left list.
     */
    public void moveSelectedLeft()
    {
        List selectedElements = new ArrayList( (List)getRightMultiSIL().getSelectedValuesHolder().getValue());
        ((List)getLeftListVM().getValue()).addAll( selectedElements);
        ((List)getRightListVM().getValue()).removeAll( selectedElements);
        ((ExternalUpdate) getLeftListVM()).signalExternalUpdate();
        ((ExternalUpdate) getRightListVM()).signalExternalUpdate();
        getLeftMultiSIL().setSelectedElements( selectedElements);
    }

    /**
     * Moves all elements from the right list to the left list.
     */
    public void moveAllLeft()
    {
        List values = new ArrayList( (List)getRightListVM().getValue());
        ((List)getLeftListVM().getValue()).addAll( values);
        ((List)getRightListVM().getValue()).clear();
        ((ExternalUpdate) getLeftListVM()).signalExternalUpdate();
        ((ExternalUpdate) getRightListVM()).signalExternalUpdate();
        getLeftMultiSIL().setSelectedElements( values);
    }

    /**
     * @return the value model that contains the {@link List} for the elements
     * on the left side
     */
    public ValueModel getLeftListVM()
    {
        return (ValueModel)mBuilder.getNonVisualObject("LeftListHolder");
    }
    
    /**
     * @return the value model that contains the {@link List} for the elements
     * on the right side
     */
    public ValueModel getRightListVM()
    {
        return (ValueModel)mBuilder.getNonVisualObject("RightListHolder");
    }
    
    /**
     * @return the {@link MultiSelectionInList} for the left list
     */
    public MultiSelectionInList getLeftMultiSIL()
    {
        return (MultiSelectionInList)mBuilder.getNonVisualObject("LeftMSIL");
    }
    
    /**
     * @return the {@link MultiSelectionInList} for the right list
     */
    public MultiSelectionInList getRightMultiSIL()
    {
        return (MultiSelectionInList)mBuilder.getNonVisualObject("RightMSIL");
    }
    
}
