package net.sf.cuf.examples;

import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.ui.SwingMapping;

import javax.swing.JFrame;
import javax.swing.JComponent;
import java.util.Locale;
import java.io.InputStream;

/**
 * small test app for SwingXMLBuilder to check many widgets etc.
 */
public class SwingXMLTest
{
    /**
     * Starts the app.
     *
     * @param args not used
     */
    public static void main(final String[] args)
    {
        // uncomment to see what happens
        //Locale.setDefault(Locale.ENGLISH);
        System.out.println("Locale:"+Locale.getDefault());

        // load description
        String      fileName   = "SwingXMLTest.xml";
        InputStream inputStream= Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        SwingXMLBuilder builder= SwingXMLBuilder.create(inputStream);

        // build+show frame
        JFrame frame   = new JFrame();
        JComponent      panel  = builder.getComponentByName("Test");
        frame.getContentPane().add(panel);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(600, 600);
        frame.show();
        frame.setVisible(true);

        // cross-check mapping
        SwingMapping mapping= SwingMapping.createMapping((JComponent)frame.getContentPane().getComponent(0));
        System.out.println(mapping);
    }
}
