package net.sf.cuf.examples;

import net.sf.cuf.ui.builder.SwingXMLBuilder;

import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.JComponent;
import java.awt.event.ActionEvent;
import java.awt.CardLayout;
import java.io.InputStream;

/**
 * small "hello world" example to demonstate the use of SwingXMLBuilder
 */
public class Layout implements SwingXMLBuilder.Backlink
{
    // our mapping helper
    private SwingXMLBuilder mBuilder;

    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * Quits the application
     * @param e not used
     */
    public void quit(final ActionEvent e)
    {
        System.out.println("quit");
        System.exit(0);
    }

    /**
     * Read the text from the text field, and use it as a card name for the cardlayout,
     * switch to that card.
     * @param e not used
     */
    public void switchToCard(final ActionEvent e)
    {
        JComponent source    = (JComponent)e.getSource();
        String     sourceName= mBuilder.getNameByComponent(source);
        JTextField textField= (JTextField)
                mBuilder.getComponentByName(sourceName+"/../TextField");
        String     cardName = textField.getText();
        JPanel     panel    = (JPanel)
                mBuilder.getComponentByName(sourceName+"/../CardPanel");
        ((CardLayout)panel.getLayout()).show(panel, cardName);
        textField.selectAll();
    }

    public void toggleVisability()
    {
        boolean isVisible= !mBuilder.getByShortName("rLabel").isVisible();
        mBuilder.getByShortName("rLabel").setVisible(isVisible);
        mBuilder.getByShortName("dLabel").setVisible(isVisible);
        mBuilder.getByShortName("rTF").setVisible(isVisible);
        mBuilder.getByShortName("dTF").setVisible(isVisible);
    }

    /**
     * Starts the app.
     *
     * @param args not used
     */
    public static void main(final String[] args)
    {
        // create pk first, push it to builder
        String          fileName= "Layout.xml";
        InputStream     input   = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        SwingXMLBuilder builder = SwingXMLBuilder.create(input);

        // make the frames visible
        JFrame borderFrame= (JFrame)builder.getContainerByName("BorderFrame");
        borderFrame.pack();

        JFrame boxFrame= (JFrame)builder.getContainerByName("BoxFrame");
        boxFrame.pack();

        JFrame cardFrame= (JFrame)builder.getContainerByName("CardFrame");
        cardFrame.pack();

        JFrame flowFrame= (JFrame)builder.getContainerByName("FlowFrame");
        flowFrame.pack();

        JFrame gridFrame= (JFrame)builder.getContainerByName("GridFrame");
        gridFrame.pack();

        JFrame tableFrame= (JFrame)builder.getContainerByName("TableFrame");
        tableFrame.pack();

        JFrame formFrame= (JFrame)builder.getContainerByName("FormFrame");
        formFrame.pack();

        JFrame formFrame2= (JFrame)builder.getContainerByName("FormFrame2");
        formFrame2.pack();

        borderFrame.show();
        boxFrame.show();
        cardFrame.show();
        flowFrame.show();
        gridFrame.show();
        tableFrame.show();
        formFrame.show();
        formFrame2.show();
    }
}
