package net.sf.cuf.examples;

import net.sf.cuf.ui.builder.SwingXMLBuilder;

import javax.swing.JFrame;
import java.awt.event.ActionEvent;
import java.io.InputStream;

/**
 * small "hello world" example to demonstrate the use of SwingXMLBuilder
 */
public class HalloWelt
{
    /**
     * Our "business" method just prints "Hallo Welt".
     * @param e not used
     */
    public void hallo(final ActionEvent e)
    {
        System.out.println("Hallo Welt");
    }

    /**
     * Quits the application
     * @param e not used
     */
    public void quit(final ActionEvent e)
    {
        System.out.println("quit");
        System.exit(0);
    }

    /**
     * Starts the app.
     * @param args not used
     */
    public static void main(final String[] args)
    {
        String          fileName= "HalloWelt.xml";
        InputStream     input   = Thread.currentThread().getContextClassLoader()
                                  .getResourceAsStream(fileName);
        SwingXMLBuilder builder = SwingXMLBuilder.create(input);

        // make the frame visible
        JFrame frame= (JFrame)builder.getContainerByName("myFrame");
        frame.pack();
        frame.show();
    }
}
