/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples;

import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class Layout
implements SwingXMLBuilder.Backlink {
    private SwingXMLBuilder mBuilder;

    public void setSwingXMLBuilder(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void quit(ActionEvent e) {
        System.out.println("quit");
        System.exit(0);
    }

    public void switchToCard(ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        String sourceName = this.mBuilder.getNameByComponent(source);
        JTextField textField = (JTextField)this.mBuilder.getComponentByName(sourceName + "/../TextField");
        String cardName = textField.getText();
        JPanel panel = (JPanel)this.mBuilder.getComponentByName(sourceName + "/../CardPanel");
        ((CardLayout)panel.getLayout()).show(panel, cardName);
        textField.selectAll();
    }

    public void toggleVisability() {
        boolean isVisible = !this.mBuilder.getByShortName("rLabel").isVisible();
        this.mBuilder.getByShortName("rLabel").setVisible(isVisible);
        this.mBuilder.getByShortName("dLabel").setVisible(isVisible);
        this.mBuilder.getByShortName("rTF").setVisible(isVisible);
        this.mBuilder.getByShortName("dTF").setVisible(isVisible);
    }

    public static void main(String[] args) {
        String fileName = "Layout.xml";
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        SwingXMLBuilder builder = SwingXMLBuilder.create((InputStream)input);
        JFrame borderFrame = (JFrame)builder.getContainerByName("BorderFrame");
        borderFrame.pack();
        JFrame boxFrame = (JFrame)builder.getContainerByName("BoxFrame");
        boxFrame.pack();
        JFrame cardFrame = (JFrame)builder.getContainerByName("CardFrame");
        cardFrame.pack();
        JFrame flowFrame = (JFrame)builder.getContainerByName("FlowFrame");
        flowFrame.pack();
        JFrame gridFrame = (JFrame)builder.getContainerByName("GridFrame");
        gridFrame.pack();
        JFrame tableFrame = (JFrame)builder.getContainerByName("TableFrame");
        tableFrame.pack();
        JFrame formFrame = (JFrame)builder.getContainerByName("FormFrame");
        formFrame.pack();
        JFrame formFrame2 = (JFrame)builder.getContainerByName("FormFrame2");
        formFrame2.pack();
        borderFrame.show();
        boxFrame.show();
        cardFrame.show();
        flowFrame.show();
        gridFrame.show();
        tableFrame.show();
        formFrame.show();
        formFrame2.show();
    }
}

