package net.sf.cuf.examples.model.uc3;

import net.sf.cuf.fw2.DialogDc;
import net.sf.cuf.fw2.AbstractDialogDc;
import net.sf.cuf.fw2.DialogDescription;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.examples.model.AppData;

import java.util.Map;
import java.util.HashMap;
import java.io.InputStream;

/**
 * UseCase3Dc is the dialog component of a very simple dialog.
 * It demonstrates the "show modal dialog" mechanism.
 */
public class UseCase3Dc extends AbstractDialogDc implements DialogDc
{
    /** our presentation peer */
    private UseCase3Pc mPc;

    /** the builder that created our Pc and UI */
    private SwingXMLBuilder mBuilder;

    /**
     * This method is called by the parent dialog controller during
     * the initialisation phase of an application.<br/>
     *
     * @param pParent our parent must implement AppEventSupport
     * @param pArgs variable argument list modeled as a key/value map, never null.
     */
    public void init(final Dc pParent, final Map<String, ? super Object> pArgs)
    {
        super.init(pParent, pArgs);

        // load + init our modal dialog
        Application app= (Application)pArgs.get(Application.APPLICATION_KEY);
        Map knownDialogs= DialogDescription.loadKnownDialogs(AppData.UC3_DIALOGS);
        DialogDescription.initDialogs(knownDialogs, app, this, pArgs);
        mDialogManager.setKnownDialogs(knownDialogs);

        // load our Pc and its UI
        InputStream in= Thread.currentThread().getContextClassLoader().getResourceAsStream(AppData.XML_APP_UC3_NAME);
        Map         nonVisual= new HashMap();
        nonVisual.put("UseCase3Dc", this);
        mBuilder= SwingXMLBuilder.create(in, nonVisual);
        mPc= (UseCase3Pc)mBuilder.getNonVisualObject("UseCase3Pc");
        mPc.init(this, pArgs);
    }

    /**
     * Called from the dialog coordinator to tell the dialog to switch
     * to the active state.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void doActivate(final Map<String, ? super Object> pArgs)
    {
        System.out.println("UseCase3Dc.doActivate");
    }

    /**
     * Test to check if a dialog in the active state can be moved
     * to the passive state, we ask our presentation component if
     * it is o.k. to passivate.
     * @return true if the dialog can be passivated
     */
    public boolean canPassivate()
    {
        return true;
    }

    /**
     * Called from the dialog coordinator to tell the dialog to switch
     * to the passive state.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void doPassivate(final Map<String, ? super Object> pArgs)
    {
        System.out.println("UseCase3Dc.doPassivate");
    }

    /**
     * Called from the dialog coordinator to tell the dialog to cleanup all
     * resources. We only call dispose of our Pc.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void dispose(final Map<String, ? super Object> pArgs)
    {
        mPc.dispose(pArgs);
    }

    /**
     * Called from the dialog coordinater in the initialized, active or passive
     * state to get the visual representation for this dialog.
     * @return an object that represents the visual representation of this dialog
     */
    public Object getVisualPresentation()
    {
        return mPc.getVisualPresentation();
    }
}
