package net.sf.cuf.fw;

import javafx.application.Application;
import javafx.application.Platform;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * Base class for a CUF JavaFX application.
 */
public abstract class AbstractFxApplication extends Application implements net.sf.cuf.fw.Application
{
    /** Our properties, never null. */
    protected Properties            mAppProperties= new Properties();
    /** Our map for the models, never null. */
    protected Map<String, Object>   mAppModels    = new HashMap<>();

    /** {@inheritDoc} */
    @Override
    public String getProperty(final String pKey, final String pDefault)
    {
        return mAppProperties.getProperty(pKey, pDefault);
    }

    /** {@inheritDoc} */
    @Override
    public void setProperty(final String pKey, final String pValue)
    {
        mAppProperties.setProperty(pKey, pValue);
    }

    /** {@inheritDoc} */
    @Override
    public Properties getProperties()
    {
        return mAppProperties;
    }

    /** {@inheritDoc} */
    @Override
    public Map<String, ? super Object> getAppModel()
    {
        return mAppModels;
    }

    /** {@inheritDoc} */
    @Override
    public void doStart(String[] pArgs)
    {
        // for a JavaFX application this method makes no sense, because start is called anyway
    }

    /** {@inheritDoc} */
    @Override
    public void doStop()
    {
        // this will call stop()
        Platform.exit();
        System.exit(0);
    }
}
