package net.sf.cuf.xfer;

import javafx.application.Platform;

/**
 * The dispatcher class provides methods to produce and dispatch
 * a response object from a request object in a JavaFX environemnt, so
 * {@link #asyncDispatchInEDT(Request)} will use the JavaFX application thread,
 * not the Swing EDT.<br/>
 * Because this implementation has no state, it may be used as
 * a static instance for dispatching.
 */
public class JavaFXDispatcher extends AbstractDispatcher implements Dispatch
{
    /**
     * Create a (stateless) dispatcher.
     */
    public JavaFXDispatcher()
    {
    }

    /** {@inheritDoc} */
    @Override
    protected void doDispatch(final Runnable pRunnable)
    {
        Platform.runLater(pRunnable);
    }
}
