/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.appevent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventListener;

public class BindEvent<T extends AppEvent>
extends AppEvent {
    private AppEventListener<T> mMethodToCallBack;
    private Class<T> mAppEventToBindTo;
    private int mHopCount;

    public BindEvent(Object pSource, AppEventListener<T> pMethodToCallBack, Class<T> pAppEventToBindTo) {
        this(pSource, pMethodToCallBack, pAppEventToBindTo, 0);
    }

    public BindEvent(Object pSource, AppEventListener<T> pMethodToCallBack, Class<T> pAppEventToBindTo, int pHopCount) {
        super(pSource);
        if (pSource == null) {
            throw new IllegalArgumentException("pSource must not be null");
        }
        if (pMethodToCallBack == null) {
            throw new IllegalArgumentException("pMethodToCallBack must not be null");
        }
        if (pAppEventToBindTo == null) {
            throw new IllegalArgumentException("pAppEventToBindTo must not be null");
        }
        if (!AppEvent.class.isAssignableFrom(pAppEventToBindTo)) {
            throw new IllegalArgumentException(pAppEventToBindTo.getName() + " is not derived from AppEvent");
        }
        if (pHopCount < 0) {
            throw new IllegalArgumentException("pHopCount must be >= 0");
        }
        this.mMethodToCallBack = pMethodToCallBack;
        this.mAppEventToBindTo = pAppEventToBindTo;
        this.mHopCount = pHopCount;
        if (this.mHopCount == 0) {
            this.mHopCount = -1;
        }
    }

    public BindEvent(Object pSource, String pMethodToCallBack, Class<T> pAppEventToBindTo) {
        this(pSource, pMethodToCallBack, pAppEventToBindTo, 0);
    }

    public BindEvent(Object pSource, String pMethodToCallBack, Class<T> pAppEventToBindTo, int pHopCount) {
        super(pSource);
        if (pSource == null) {
            throw new IllegalArgumentException("pSource must not be null");
        }
        if (pMethodToCallBack == null) {
            throw new IllegalArgumentException("pMethodToCallBack must not be null");
        }
        if (pAppEventToBindTo == null) {
            throw new IllegalArgumentException("pAppEventToBindTo must not be null");
        }
        if (!AppEvent.class.isAssignableFrom(pAppEventToBindTo)) {
            throw new IllegalArgumentException(pAppEventToBindTo.getName() + " is not derived from AppEvent");
        }
        if (pHopCount < 0) {
            throw new IllegalArgumentException("pHopCount must be >= 0");
        }
        if (!Modifier.isPublic(pSource.getClass().getModifiers())) {
            throw new IllegalArgumentException("pSource must be an object from a public class");
        }
        try {
            Method methodToCallBack = pSource.getClass().getMethod(pMethodToCallBack, pAppEventToBindTo);
            if (!Modifier.isPublic(methodToCallBack.getModifiers())) {
                throw new IllegalArgumentException(pMethodToCallBack + " isn't a public method");
            }
            this.mMethodToCallBack = pAppEvent -> {
                try {
                    Object[] args = new Object[]{pAppEvent};
                    methodToCallBack.invoke(pSource, args);
                }
                catch (IllegalAccessException iae) {
                    throw new IllegalStateException(iae.toString(), iae);
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getTargetException();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new IllegalArgumentException(cause != null ? cause.getMessage() : ite.getMessage(), cause);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.mAppEventToBindTo = pAppEventToBindTo;
        this.mHopCount = pHopCount;
        if (this.mHopCount == 0) {
            this.mHopCount = -1;
        }
    }

    @Override
    public void forward() {
        if (this.mHopCount < 0) {
            return;
        }
        if (this.mHopCount < 1) {
            this.consume();
        }
        --this.mHopCount;
    }

    public AppEventListener getMethodToCallBack() {
        return this.mMethodToCallBack;
    }

    public Class<T> getTriggerClass() {
        return this.mAppEventToBindTo;
    }
}

