package net.sf.cuf.fw2;

import net.sf.cuf.appevent.AppEvent;

/**
 * A ShowStatusEvent can be used by any Dc/Pc to change the status
 * bar of an application.
 */
public class ShowStatusEvent extends AppEvent
{
    /** status text, never null */
    private String mStatusText= "";

    /**
     * Create a non-consumed event with an empty string.
     * @param pSource event source
     */
    public ShowStatusEvent(final Object pSource)
    {
        super(pSource);
    }

    /**
     * Create a non-consumed event.
     * @param pSource event source
     * @param pStatusText the new status text, must not be null
     * @throws IllegalArgumentException if pStatusText is null
     */
    public ShowStatusEvent(final Object pSource, final String pStatusText)
    {
        super(pSource);
        if (pStatusText==null)
        {
            throw new IllegalArgumentException("status text must not be null");
        }
        mStatusText= pStatusText;
    }

    /**
     * Returns our status text.
     * @return status string, never null
     */
    public String getStatusText()
    {
        return mStatusText;
    }
}
