package net.sf.cuf.fw2;

import java.util.Map;

/**
 * The SimpleLifeCycle interface describes a part of a more complex
 * lifecycle, and is used to encapsulate the common life cycle of
 * AppDc and DialogDc. <br>
 * The lifecycle that is described by the SimpleLifeCyce interface is
 * shown below:
 * <code>
 *               doActivate()          doPassivate()
 * [initialized] -----------&gt; [active] ------------&gt; [passive]
 *                                     &lt;------------
 *                                     doActivate()
 * </code>
 * The arguments of the doActivate() and doPassivate() calls may
 * also be used to return stuff to the caller.
 */
public interface SimpleLifeCycle
{
    /**
     * Test to check if a dialog in the active state can be moved
     * to the passive state.<br>
     * The dialog may e.g. check if it has unsaved data and prompt the user
     * for information how to proceed.<br>
     * If the dialog returns true, it may be moved to the passive state by
     * a call to doPassivate(), if it returns false, it will remain in the
     * active state and no doPassivate() call will happen.
     * @return true if the dialog can be passivated
     */
    boolean canPassivate();

    /**
     * Called from the dialog coordinator to tell the dialog to switch
     * to the active state. If the dialog is an modal dialog, this method
     * returns after the dialog closed.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    void    doActivate (Map<String, ? super Object> pArgs);

    /**
     * Called from the dialog coordinator to tell the dialog to switch
     * to the passive state. If the dialog is a modal dialog, this method is
     * called "inside" the doActivate() method.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    void    doPassivate(Map<String, ? super Object> pArgs);
}
