/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.xfer;

import net.sf.cuf.xfer.DefaultDispatchTarget;
import net.sf.cuf.xfer.DispatchTarget;
import net.sf.cuf.xfer.Request;
import net.sf.cuf.xfer.RequestDelegate;

public abstract class AbstractRequest<T>
implements Request<T> {
    private RequestDelegate<T> mDelegate = null;
    private DispatchTarget<T> mTarget = null;

    public AbstractRequest() {
        String delegateClassName = System.getProperty(this.getClass().getName() + ".delegate");
        if (delegateClassName != null) {
            try {
                AbstractRequest<Object> delegate = delegateClassName.equals(this.getClass().getName()) ? this : Class.forName(delegateClassName).newInstance();
                if (delegate instanceof RequestDelegate) {
                    this.mDelegate = (RequestDelegate)((Object)delegate);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setDispatchTarget(DispatchTarget<T> pTarget) {
        this.mTarget = pTarget;
    }

    @Override
    public void setDispatchTarget(Object pTargetObject, String pMethodName) {
        DefaultDispatchTarget target = new DefaultDispatchTarget(pTargetObject, pMethodName);
        this.setDispatchTarget(target);
    }

    @Override
    public DispatchTarget<T> getDispatchTarget() {
        return this.mTarget;
    }

    @Override
    public RequestDelegate<T> getDelegate() {
        return this.mDelegate;
    }

    @Override
    public boolean canBeCancelled() {
        return false;
    }

    @Override
    public void cancel() throws IllegalStateException {
        throw new IllegalStateException("this request can't be canceled");
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof AbstractRequest)) {
            return false;
        }
        AbstractRequest abstractRequest = (AbstractRequest)pOther;
        if (this.mDelegate != null ? !this.mDelegate.equals(abstractRequest.mDelegate) : abstractRequest.mDelegate != null) {
            return false;
        }
        return !(this.mTarget != null ? !this.mTarget.equals(abstractRequest.mTarget) : abstractRequest.mTarget != null);
    }

    public int hashCode() {
        int result = this.mDelegate != null ? this.mDelegate.hashCode() : 0;
        result = 29 * result + (this.mTarget != null ? this.mTarget.hashCode() : 0);
        return result;
    }

    public String toString() {
        return super.toString() + "[target=" + this.mTarget + ", delegate=" + this.mDelegate + ']';
    }
}

