package net.sf.cuf.xfer;

/**
 * The Dispatch Interface provides methods to produce and dispatch
 * a response object from a request object.
 */
public interface Dispatch
{
    /**
     * Generate a response and and dispatch it in a new (seperate) thread.
     * @param pRequest the request
     * @param <T> Generic type of the {@link Request pRequest}.
     */
    <T> void asyncDispatch(final Request<T> pRequest);

    /**
     * Generate a response in a new (seperate) thread and dispatch the
     * response in the EDT (event dispatch thread).
     * @param pRequest the request
     * @param <T> Generic type of the {@link Request pRequest}.
     */
    <T> void asyncDispatchInEDT(final Request<T> pRequest);

    /**
     * Generate a response (includes delegate handling) but doesn't dispatch the response.
     * @param pRequest the request
     * @return the response
     * @param <T> Generic type of the {@link Request pRequest}.
     */
    <T> Response<T> syncExecute(final Request<T> pRequest);

    /**
     * Generate a response and and dispatch it in the current thread.
     * @param pRequest the request
     * @param <T> Generic type of the {@link Request pRequest}.
     */
    <T> void syncDispatch(final Request<T> pRequest);
}
