package net.sf.cuf.xfer;

/**
 * DefaultResponse is a default implementation for the Response interface.
 * In almost all cases this implementation is sufficient.
 */
public class DefaultResponse<T> implements Response<T>
{
    /** our error or result */
    private Object  mErrorOrResult;
    /** flag if we have an error or a result */
    private boolean mIsValid;
    /** flag if we where cancelled */
    private boolean mWasCancelled;

    /**
     * Creates an invalid response with a null error object that was not cancelled.
     */
    public DefaultResponse()
    {
        this(false);
    }

    /**
     * Creates an invalid response with a null error object.
     * @param pWasCancelled true if the request was cancelled
     */
    public DefaultResponse(final boolean pWasCancelled)
    {
        mIsValid      = false;
        mWasCancelled = pWasCancelled;
        mErrorOrResult= null;
    }

    @Override
    public boolean isValid()
    {
        return mIsValid;
    }

    @Override
    public boolean wasCancelled()
    {
        return mWasCancelled;
    }

    @Override
    public synchronized void setError(final Object pError)
    {
        mErrorOrResult= pError;
        mIsValid      = false;
    }

    @Override
    public Object getError()
    {
        if (mIsValid)
            return null;
        else
            return mErrorOrResult;
    }

    @Override
    public synchronized void setResult(final Object pResponse)
    {
        mErrorOrResult= pResponse;
        mIsValid      = true;
    }

    @Override
    public T getResult()
    {
        if (mIsValid)
            return (T) mErrorOrResult;
        else
            return null;
    }

    @Override
    public boolean equals(final Object pOther)
    {
        if (!(pOther instanceof DefaultResponse))
            return false;

        DefaultResponse defaultResponse = (DefaultResponse) pOther;

        if (mIsValid != defaultResponse.mIsValid)
        {
            return false;
        }

        return !(mErrorOrResult != null ? !mErrorOrResult.equals(defaultResponse.mErrorOrResult) : defaultResponse.mErrorOrResult != null);

    }

    @Override
    public int hashCode()
    {
        int result= 0;
        if (mIsValid)
            result= 1;
        result |= (mErrorOrResult != null ? mErrorOrResult.hashCode() : 0);
        return result;
    }

    @Override
    public String toString()
    {
        return super.toString() + "[valid=" +
               mIsValid +
               ",errorOrResult=" +
               mErrorOrResult +
               ']';
    }
}
