package net.sf.cuf.fw;

import java.util.Map;

/**
 * This interface describes all methods common to dialog controllers.<br>
 * These common methods mainly describe the life cycle of a dialog
 * controller and the services it provides.<br>
 */
public interface Dc
{
    /**
     * This method is called by the parent dialog controller during
     * the initialisation phase of an application.<br>
     * An implementation should first initialize all of its sub-controllers
     * (if there are any) and then initialize its presentation component.<br>
     * All arguments are handed in with a map object, that map always
     * contains the application object with the key
     * <code>Application.APPLICATION_KEY</code>.
     * The map should <b>not</b> be altered inside the method.
     *
     * @param pParent null or parent dialog controller. If pParent is null,
     *                the Dc is a top-level dialog controller.
     * @param pArgs variable argument list modeled as a key/value map, never null.
     */
    void init(Dc pParent, Map<String, ? super Object> pArgs);
}
