/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.xfer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cuf.xfer.DispatchTarget;
import net.sf.cuf.xfer.Response;

public class DefaultDispatchTarget<T>
implements DispatchTarget<T> {
    private Object mTargetObject;
    private Method mTargetMethod;

    public DefaultDispatchTarget(Object pTargetObject, String pMethodName) throws IllegalArgumentException {
        Method method;
        if (pTargetObject == null) {
            throw new IllegalArgumentException("pTargetObject must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("pMethodName must not be null");
        }
        if (!Modifier.isPublic(pTargetObject.getClass().getModifiers())) {
            throw new IllegalArgumentException("pTargetObject must be an object from a public class");
        }
        Class[] params = new Class[]{Response.class};
        try {
            method = pTargetObject.getClass().getMethod(pMethodName, params);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No method: " + e.getMessage(), e);
        }
        this.mTargetObject = pTargetObject;
        this.mTargetMethod = method;
    }

    @Override
    public void callback(Response<T> pResponse) {
        try {
            Object[] args = new Object[]{pResponse};
            this.mTargetMethod.invoke(this.mTargetObject, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalArgumentException(cause != null ? cause.getMessage() : e.getMessage(), cause != null ? cause : e);
        }
    }

    public boolean equals(Object pObject) {
        if (pObject == this) {
            return true;
        }
        if (!(pObject instanceof DefaultDispatchTarget)) {
            return false;
        }
        DefaultDispatchTarget target = (DefaultDispatchTarget)pObject;
        if (target.mTargetObject != this.mTargetObject) {
            return false;
        }
        if (this.mTargetMethod == null) {
            return target.mTargetMethod == null;
        }
        return target.mTargetMethod.getName().equals(this.mTargetMethod.getName());
    }

    public int hashCode() {
        return this.mTargetObject.hashCode() | this.mTargetMethod.hashCode();
    }

    public String toString() {
        return super.toString() + "[targetObject=" + this.mTargetObject + ",targetMethod=" + this.mTargetMethod + ']';
    }
}

