/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.fw2;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;

public class DialogDescription {
    private static final String DIALOG_PREFIX = "dialog";
    private static final String[] EXPLICIT_PARAMS = new String[]{"id", "class", "name", "icon"};
    private String mDialogId;
    private Class<? extends Dc> mDialogClass;
    private String mDialogName;
    private String mDialogIcon;
    private Map<String, Object> mParameters;
    private Dc mDc;

    public static Map<String, DialogDescription> loadKnownDialogs(String pFileName) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(pFileName);
        if (in == null) {
            throw new IllegalArgumentException("No input resource found for name " + pFileName);
        }
        Properties props = new Properties();
        try {
            props.load(in);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load input resource for name " + pFileName, e);
        }
        ArrayList<DialogDescription> dialogs = new ArrayList<DialogDescription>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int firstDot = key.indexOf(46);
            int lastDot = key.lastIndexOf(46);
            if (firstDot < 0 || lastDot < 0 || firstDot >= lastDot) continue;
            try {
                int index = Integer.parseInt(key.substring(lastDot + 1));
                if (index < 0) break;
                if (index >= dialogs.size()) {
                    int gap;
                    for (int i = gap = index - dialogs.size(); i >= 0; --i) {
                        dialogs.add(new DialogDescription());
                    }
                }
                String token = key.substring(firstDot + 1, lastDot);
                if (!DIALOG_PREFIX.equals(key.substring(0, firstDot))) continue;
                DialogDescription dialogDescription2 = (DialogDescription)dialogs.get(index);
                if (EXPLICIT_PARAMS[0].equals(token)) {
                    dialogDescription2.setDialogId(value);
                    continue;
                }
                if (EXPLICIT_PARAMS[1].equals(token)) {
                    dialogDescription2.setDialogClassName(value);
                    continue;
                }
                if (EXPLICIT_PARAMS[2].equals(token)) {
                    dialogDescription2.setDialogName(value);
                    continue;
                }
                if (EXPLICIT_PARAMS[3].equals(token)) {
                    dialogDescription2.setDialogIcon(value);
                    continue;
                }
                dialogDescription2.addParameter(token, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        dialogs.removeIf(dialogDescription -> dialogDescription == null || !dialogDescription.isComplete());
        LinkedHashMap<String, DialogDescription> knownDialogs = new LinkedHashMap<String, DialogDescription>(dialogs.size());
        for (DialogDescription dialogDescription3 : dialogs) {
            knownDialogs.put(dialogDescription3.getDialogId(), dialogDescription3);
        }
        return knownDialogs;
    }

    public static void initDialogs(Map<String, DialogDescription> pKnownDialogs, Application pApp, Dc pParent, Map<String, ? super Object> pArgs) {
        if (pKnownDialogs == null) {
            throw new IllegalArgumentException("know dialogs must not be null");
        }
        if (pApp == null) {
            throw new IllegalArgumentException("application must not be null");
        }
        for (DialogDescription o : pKnownDialogs.values()) {
            DialogDescription description = o;
            Dc dc = description.getDc();
            if (dc != null) continue;
            Class<? extends Dc> c = description.getDialogClass();
            try {
                dc = c.newInstance();
                HashMap<String, ? super Object> args = new HashMap<String, Object>();
                if (description.getParameters() != null) {
                    args.putAll(description.getParameters());
                }
                args.putAll(pArgs);
                args.put("Application", pApp);
                dc.init(pParent, args);
                description.setDc(dc);
            }
            catch (Exception e) {
                throw new RuntimeException("could not initialize dialog with id " + description.mDialogId + ": " + e, e);
            }
        }
    }

    public boolean isComplete() {
        return this.mDialogId != null && this.mDialogClass != null;
    }

    public String getDialogId() {
        return this.mDialogId;
    }

    public void setDialogId(String pDialogId) {
        if (pDialogId == null) {
            throw new IllegalArgumentException("dialog id must not be null");
        }
        this.mDialogId = pDialogId;
    }

    public Class<? extends Dc> getDialogClass() {
        return this.mDialogClass;
    }

    public void setDialogClass(Class<? extends Dc> pDialogClass) {
        if (!Dc.class.isAssignableFrom(pDialogClass)) {
            throw new IllegalArgumentException("not a Dc class but a " + pDialogClass);
        }
        this.mDialogClass = pDialogClass;
    }

    public void setDialogClassName(String pDialogClassName) {
        Class<?> dialogClass;
        try {
            dialogClass = Thread.currentThread().getContextClassLoader().loadClass(pDialogClassName);
        }
        catch (Exception ignored) {
            throw new IllegalArgumentException("could not load class " + pDialogClassName, ignored);
        }
        this.setDialogClass(dialogClass);
    }

    public String getDialogName() {
        return this.mDialogName;
    }

    public void setDialogName(String pDialogName) {
        this.mDialogName = pDialogName;
    }

    public String getDialogIcon() {
        return this.mDialogIcon;
    }

    public void setDialogIcon(String pDialogIcon) {
        this.mDialogIcon = pDialogIcon;
    }

    public void addParameter(String pKey, Object pValue) {
        if (pKey == null) {
            throw new IllegalArgumentException("dialog parameter key must not be null");
        }
        if (pValue == null) {
            throw new IllegalArgumentException("dialog parameter value must not be null");
        }
        if (this.mParameters == null) {
            this.mParameters = new HashMap<String, Object>();
        }
        this.mParameters.put(pKey, pValue);
    }

    public Map<String, Object> getParameters() {
        return this.mParameters;
    }

    public void setParameters(Map<String, Object> pParameters) {
        this.mParameters = pParameters;
    }

    public Dc getDc() {
        return this.mDc;
    }

    public void setDc(Dc pDc) {
        this.mDc = pDc;
    }
}

