/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.fw2;

import net.sf.cuf.appevent.AppEvent;

public class BlockEvent
extends AppEvent {
    private final boolean mBlock;
    private final long mEstimatedBlockDuration;
    private final boolean mReFocus;

    public static BlockEvent createBlockEvent(Object pSource) {
        return new BlockEvent(pSource, true);
    }

    public static BlockEvent createUnBlockEvent(Object pSource) {
        return new BlockEvent(pSource, false);
    }

    public static BlockEvent createNoRefocusUnBlockEvent(Object pSource) {
        return new BlockEvent(pSource, false, -1L, false);
    }

    public BlockEvent(Object pSource, boolean pBlock) {
        this(pSource, pBlock, -1L, true);
    }

    public BlockEvent(Object pSource, long pEstimatedBlockDuration) {
        this(pSource, true, pEstimatedBlockDuration, true);
    }

    public BlockEvent(Object pSource, boolean pBlock, long pEstimatedBlockDuration, boolean pReFocus) {
        super(pSource);
        if (pEstimatedBlockDuration < 0L && pEstimatedBlockDuration != -1L) {
            throw new IllegalArgumentException("block duration must be -1 or >=0 and not " + pEstimatedBlockDuration);
        }
        this.mBlock = pBlock;
        this.mEstimatedBlockDuration = pEstimatedBlockDuration;
        this.mReFocus = pReFocus;
    }

    public boolean isBlock() {
        return this.mBlock;
    }

    public long getEstimatedBlockDuration() {
        return this.mEstimatedBlockDuration;
    }

    public boolean isReFocus() {
        return this.mReFocus;
    }
}

