/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.fw2;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventManager;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.BindEvent;
import net.sf.cuf.appevent.UnbindEvent;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.AppDc;
import net.sf.cuf.fw2.BlockEvent;
import net.sf.cuf.fw2.DialogManager;
import net.sf.cuf.fw2.MenuToolBarEvent;
import net.sf.cuf.fw2.ShowStatusEvent;

public abstract class AbstractAppDc
implements AppDc {
    protected AppEventManager mAppEventManger;
    protected AppEventSupport mAppEventSupport;
    protected DialogManager mDialogManager;
    protected static final List<Class<? extends AppEvent>> BLOCKED_EVENTS = Arrays.asList(MenuToolBarEvent.class, ShowStatusEvent.class, BlockEvent.class);

    @Override
    public void init(Dc pParent, Map<String, ? super Object> pArgs) {
        Object application = pArgs.get("Application");
        this.mAppEventSupport = (AppEventSupport)application;
        this.mAppEventManger = new AppEventManager();
        this.mDialogManager = new DialogManager((Application)application);
    }

    @Override
    public Dc getActiveDialog() {
        return this.mDialogManager.getActiveDialog();
    }

    @Override
    public List<Dc> getActiveDialogs() {
        return this.mDialogManager.getActiveDialogs();
    }

    @Override
    public void postAppEvent(AppEvent pAppEvent) {
        if (pAppEvent instanceof BindEvent) {
            if (BLOCKED_EVENTS.contains(((BindEvent)pAppEvent).getTriggerClass())) {
                this.mAppEventManger.postAppEvent(pAppEvent);
            }
        } else if (pAppEvent instanceof UnbindEvent) {
            if (BLOCKED_EVENTS.contains(((UnbindEvent)pAppEvent).getTriggerClass())) {
                this.mAppEventManger.postAppEvent(pAppEvent);
            }
        } else if (BLOCKED_EVENTS.contains(pAppEvent.getClass())) {
            this.mAppEventManger.postAppEvent(pAppEvent);
        }
        pAppEvent.forward();
        if (!pAppEvent.isConsumed()) {
            this.mDialogManager.postAppEvent(this, this.mAppEventSupport, pAppEvent);
        }
    }

    @Override
    public void dispose(Map<String, ? super Object> pArgs) {
    }
}

