/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.xfer;

import net.sf.cuf.xfer.Response;

public class DefaultResponse<T>
implements Response<T> {
    private Object mErrorOrResult;
    private boolean mIsValid = false;
    private boolean mWasCancelled;

    public DefaultResponse() {
        this(false);
    }

    public DefaultResponse(boolean pWasCancelled) {
        this.mWasCancelled = pWasCancelled;
        this.mErrorOrResult = null;
    }

    @Override
    public boolean isValid() {
        return this.mIsValid;
    }

    @Override
    public boolean wasCancelled() {
        return this.mWasCancelled;
    }

    @Override
    public synchronized void setError(Object pError) {
        this.mErrorOrResult = pError;
        this.mIsValid = false;
    }

    @Override
    public Object getError() {
        if (this.mIsValid) {
            return null;
        }
        return this.mErrorOrResult;
    }

    @Override
    public synchronized void setResult(Object pResponse) {
        this.mErrorOrResult = pResponse;
        this.mIsValid = true;
    }

    @Override
    public T getResult() {
        if (this.mIsValid) {
            return (T)this.mErrorOrResult;
        }
        return null;
    }

    public boolean equals(Object pOther) {
        if (!(pOther instanceof DefaultResponse)) {
            return false;
        }
        DefaultResponse defaultResponse = (DefaultResponse)pOther;
        if (this.mIsValid != defaultResponse.mIsValid) {
            return false;
        }
        return !(this.mErrorOrResult == null ? defaultResponse.mErrorOrResult != null : !this.mErrorOrResult.equals(defaultResponse.mErrorOrResult));
    }

    public int hashCode() {
        int result = 0;
        if (this.mIsValid) {
            result = 1;
        }
        return result |= this.mErrorOrResult != null ? this.mErrorOrResult.hashCode() : 0;
    }

    public String toString() {
        return super.toString() + "[valid=" + this.mIsValid + ",errorOrResult=" + this.mErrorOrResult + ']';
    }
}

