package net.sf.cuf.fw2;

import net.sf.cuf.fw.Pc;
import net.sf.cuf.appevent.AppEventSupport;

/**
 * A DialogPc enhances the basic Pc interface with
 * <ul>
 * <li>support for AppEvent's,
 * <li>a standardized interface for a DialogDc to get the visual
 *  presentation for the dialog and
 * <li> a dispose() method for an enhanced lifecycle.
 * </ul>
 */
public interface DialogPc extends Pc, AppEventSupport, Disposable
{
    /**
     * Called from the DialogDc peer in the initialized, active or passive
     * state to get the visual representation for this dialog.
     * @return an object that represents the visual representation of this dialog
     */
    Object getVisualPresentation();
}
