package net.sf.cuf.fw2;

import net.sf.cuf.fw.Application;
import net.sf.cuf.appevent.AppEventSupport;

/**
 * A DialogApplication enhances the basic Application interface
 * with support for AppEvent's and a more complex dialog management.
 * There is exactly one DialogApplication object in an application,
 * there is one AppDc/AppPc pair for each top level application window,
 * and there is any number of DialogDc/DialogPc pairs for each
 * AppDc/AppPc pair.
 */
public interface DialogApplication extends Application, AppEventSupport
{
    /**
     * Key for the user object in the argument map passed to
     * the init method of the Dc and Pc interfaces. The value may be null, if
     * no information is available.
     */
    String LOGIN_INFORMATION_KEY= "LoginInfo";
}
