/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.fw2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.fw.Dc;

public class OpenDialogEvent
extends AppEvent {
    private Object mDialog;
    private Map<String, Object> mDialogArguments;
    private Map<String, Object> mDialogResults;

    public OpenDialogEvent(Object pSource, String pDialogId) {
        this(pSource, pDialogId, null);
    }

    public OpenDialogEvent(Object pSource, String pDialogId, Map<String, Object> pDialogArguments) {
        this(pSource, (Object)pDialogId, pDialogArguments);
    }

    public OpenDialogEvent(Object pSource, Dc pDialog) {
        this(pSource, pDialog, null);
    }

    public OpenDialogEvent(Object pSource, Dc pDialog, Map<String, Object> pDialogArguments) {
        this(pSource, (Object)pDialog, pDialogArguments);
    }

    private OpenDialogEvent(Object pSource, Object pDialog, Map<String, Object> pDialogArguments) {
        super(pSource);
        if (pDialog == null) {
            throw new IllegalArgumentException("dialog (name) must not be null");
        }
        this.mDialog = pDialog;
        this.mDialogArguments = pDialogArguments == null ? new HashMap<String, Object>() : pDialogArguments;
        this.mDialogResults = Collections.emptyMap();
    }

    public boolean hasDialogId() {
        return this.mDialog instanceof String;
    }

    public String getDialogId() {
        if (!this.hasDialogId()) {
            throw new IllegalStateException("This OpenDialogEvent was created with no String but the Dc " + this.mDialog);
        }
        return (String)this.mDialog;
    }

    public Dc getDialog() {
        if (this.hasDialogId()) {
            throw new IllegalStateException("This OpenDialogEvent was created with no Dc but the String " + this.mDialog);
        }
        return (Dc)this.mDialog;
    }

    public Map<String, Object> getDialogArguments() {
        return this.mDialogArguments;
    }

    public Map<String, Object> getDialogResults() {
        return this.mDialogResults;
    }

    public void setDialogResults(Map<String, Object> pDialogResults) {
        if (pDialogResults == null) {
            throw new IllegalArgumentException("dialog results must not be null");
        }
        this.mDialogResults = pDialogResults;
    }
}

