/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.appevent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.BindEvent;
import net.sf.cuf.appevent.UnbindEvent;

public class AppEventManager
implements AppEventSupport {
    private Map<Class<? extends AppEvent>, Map<Object, Method>> mBinding = new HashMap<Class<? extends AppEvent>, Map<Object, Method>>();

    @Override
    public void postAppEvent(AppEvent pAppEvent) {
        if (pAppEvent == null) {
            throw new IllegalArgumentException("pAppEvent must not be null");
        }
        pAppEvent.forward();
        if (pAppEvent.isConsumed()) {
            return;
        }
        if (pAppEvent instanceof BindEvent) {
            this.bind((BindEvent)pAppEvent);
        } else if (pAppEvent instanceof UnbindEvent) {
            this.unbind((UnbindEvent)pAppEvent);
        } else {
            this.dispatch(pAppEvent);
        }
    }

    public boolean isBound(AppEvent pAppEvent) {
        if (pAppEvent == null) {
            throw new IllegalArgumentException("pAppEvent must not be null");
        }
        return this.mBinding.containsKey(pAppEvent.getClass());
    }

    private void bind(BindEvent pBind) {
        Map<Object, Object> targets;
        Object target = pBind.getTarget();
        Method methodToCallBack = pBind.getMethod();
        Class<? extends AppEvent> appEventToBindTo = pBind.getTriggerClass();
        if (this.mBinding.containsKey(appEventToBindTo)) {
            targets = this.mBinding.get(appEventToBindTo);
        } else {
            targets = new LinkedHashMap();
            this.mBinding.put(appEventToBindTo, targets);
        }
        targets.put(target, methodToCallBack);
        pBind.consume();
    }

    private void unbind(UnbindEvent pUnbind) {
        Object target = pUnbind.getTarget();
        Class<? extends AppEvent> appEventToUnbind = pUnbind.getTriggerClass();
        if (this.mBinding.containsKey(appEventToUnbind)) {
            Map<Object, Method> targets = this.mBinding.get(appEventToUnbind);
            targets.remove(target);
            pUnbind.consume();
        }
    }

    private void dispatch(AppEvent pAppEvent) {
        if (!this.isBound(pAppEvent)) {
            return;
        }
        LinkedHashMap<Object, Method> targets = new LinkedHashMap<Object, Method>(this.mBinding.get(pAppEvent.getClass()));
        for (Map.Entry entry : targets.entrySet()) {
            Object target = entry.getKey();
            Method methodToCallBack = (Method)entry.getValue();
            try {
                Object[] args = new Object[]{pAppEvent};
                methodToCallBack.invoke(target, args);
            }
            catch (IllegalAccessException iae) {
                IllegalStateException e = new IllegalStateException(iae.toString());
                e.initCause(iae);
                throw e;
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                IllegalArgumentException e = new IllegalArgumentException(cause != null ? cause.getMessage() : ite.getMessage());
                e.initCause(cause);
                throw e;
            }
            if (!pAppEvent.isConsumed()) continue;
            break;
        }
    }
}

