package net.sf.cuf.xfer;

/**
 * The Response interface encapsulates the result of a request.
 * A response is either valid or not: if it is valid, getResult() will
 * return the valid result, if it is not valid, getError will return the
 * error.
 * @param <T> Type of the {@link #getResult() result}.
 */
public interface Response<T>
{
    /**
     * Checks if this Response contains a valid result.
     * @return true if this Response contains a valid result
     */
    public boolean isValid();

    /**
     * Checks if this Response was cancelled.
     * @return true if this Response was cancelled
     */
    public boolean wasCancelled();

    /**
     * Sets the error for this response and marks the response as invalid.
     * @param pError error object, may be null
     */
    public void    setError(Object pError);

    /**
     * Returns the error for this response.
     * @return the error of this response (may be null)
     */
    public Object  getError();

    /**
     * Sets the result for this response and marks the response as valid.
     * @param pResult result object, may be null
     */
    public void    setResult(T pResult);

    /**
     * Returns the result for this response.
     * @return the result of this response (may be null)
     */
    public T  getResult();
}
