package net.sf.cuf.xfer;

import java.lang.reflect.Method;

/**
 * A DispatchTarget is a convience interface that maps from object/methodname
 * to object/method.
 */
public interface DispatchTarget
{
    /**
     * Set the target and the target method.
     * @param pTargetObject the object we target
     * @param pMethodName the method to call in that object
     */
    public void setTarget(Object pTargetObject, String pMethodName);

    /**
     * Returns the target object.
     * @return the target object
     */
    public Object getTargetObject();

    /**
     * Returns the method for the target object.
     * @return the method for the target object
     */
    public Method getTargetMethod();
}
