package net.sf.cuf.fw2;

import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.fw.Dc;

import java.util.List;

/**
 * A AppDc enhances the basic Dc interface with support for AppEvent's and
 * serves as a dialog coordinator for any number of DialogDc objects.<br/>
 * There is one AppDc/AppPc pair per top-level application window.
 * If a AppDc is passivated, it usally hides its window(s). If an AppDc
 * is disposed, all windows are usally disposed, too.
 */
public interface AppDc extends Dc, SimpleLifeCycle, AppEventSupport, Disposable
{
    /**
     * Returns the active dialog. If no dialog is active, null is returned,
     * if there is more than one active dialog, it is application depended
     * which dialog is returned.
     * This method may either return a AppDc, DialogDc or a plain Dc
     * object, depending on the applications architecure.
     * @return null or the active dialog
     */
    public Dc   getActiveDialog();

    /**
     * Returns a list of the active dialogs. If there is no active dialog,
     * the list is empty. The objects in the list may be any class derived
     * from Dc.
     * @return a list with the active dialogs, never null
     */
    public List<Dc> getActiveDialogs();
}
