package net.sf.cuf.fw2;

import net.sf.cuf.appevent.AppEvent;

/**
 * A BlockEvent is used to by a Dc/Pc to signal "the user should not make any
 * further input".
 */
public class BlockEvent extends AppEvent
{
    /** true if the event is sent to block the GUI, false if the GUI should
      * be unblocked */
    private boolean mBlock;

    /** time we estimate the block will take, -1 if we don't know */
    private long    mEstimatedBlockDuration;

    /**
     * Create a non-consumed event to block or unblock the GUI.
     * @param pSource null or event source
     * @param pBlock flag if we should block (true) or unblock (false)
     */
    public BlockEvent(final Object pSource, final boolean pBlock)
    {
        super(pSource);
        mBlock                 = pBlock;
        mEstimatedBlockDuration= -1;
    }

    /**
     * Create a non-consumed event to block the GUI.
     * @param pSource null or event source
     * @param pEstimatedBlockDuration -1 or the estimated duration of the block
     */
    public BlockEvent(final Object pSource, final long pEstimatedBlockDuration)
    {
        super(pSource);

        if (pEstimatedBlockDuration<0 && pEstimatedBlockDuration!=-1)
        {
            throw new IllegalArgumentException("block duration must be -1 or >=0");
        }

        mBlock                 = true;
        mEstimatedBlockDuration= pEstimatedBlockDuration;
    }

    /**
     * Returns true if the event is sent to block the GUI, false if the GUI should
     * be unblocked.
     * @return true if GUI should be blocked
     */
    public boolean isBlock()
    {
        return mBlock;
    }

    /**
     * Returns the estimated time the block will take, -1 if we don't know.
     * @return estimated block time
     */
    public long getEstimatedBlockDuration()
    {
        return mEstimatedBlockDuration;
    }
}
