package net.sf.cuf.xfer;

/**
 * The Dispatch Interface provides methods to produce and dispatch
 * a response object from a request object.
 */
public interface Dispatch
{
    /**
     * Generate a response and and dispatch it in a new (seperate) thread.
     * @param pRequest the request
     */
    public void asyncDispatch(final Request pRequest);

    /**
     * Generate a response in a new (seperate) thread and dispatch the
     * response in the EDT (event dispatch thread).
     * @param pRequest the request
     */
    public void asyncDispatchInEDT(final Request pRequest);

    /**
     * Generate a response (includes delegate handling) but doesn't dispatch the response.
     * @param pRequest the request
     * @return the response
     */
    public Response syncExecute(final Request pRequest);

    /**
     * Generate a response and and dispatch it in the current thread.
     * @param pRequest the request
     */
    public void syncDispatch(final Request pRequest);
}
