package net.sf.cuf.xfer;

/**
 * The Request interface encapsulates all information needed for
 * generating and dispatching a response for a request.
 * A Request knows how to generate the response and who is interested
 * in the result, but is has no knowledge about the dispatching
 * process (@see Dispatch).
 */
public interface Request
{
    /**
     * Sets our dispatch target.
     * @param pTarget the target to set (null is o.k.)
     */
    public void            setDispatchTarget(DispatchTarget pTarget);
    /**
     * Sets our dispatch target.
     * @param pTargetObject target to call, must not be null
     * @param pMethodName method to call, must not be null and match the
     *        void &lt;pMethodname&gt;(Response pResponse) signature
     */
    public void            setDispatchTarget(Object pTargetObject, String pMethodName);
    /**
     * Returns our dispatch target.
     * @return dispatch target (may be null)
     */
    public DispatchTarget  getDispatchTarget();

    /**
     * Returns our request delegate.
     * @return request delegate (may be null)
     */
    public RequestDelegate getDelegate();
    /**
     * Generate a response for the current request state.
     * @return the response (must not be null)
     */
    public Response        execute();

    /**
     * A request object may be canceled if this method returns true.
     * @return true if this request can be cancelled, false otherwise
     */
    public boolean canBeCancelled();
    /**
     * Cancel the current request; if the request was completed before the
     * cancel call, the cancel call will be silently ignored.
     * @throws IllegalStateException if we can't be canceled at all
     */
    public void cancel() throws IllegalStateException;
}
