package net.sf.cuf.appevent;

/**
 * Small helper class to make implementing AppEventSupport more easy:
 * the default case is to forward the event to an objects "parent".
 */
public class AppEventUtil
{
    /**
     * private constructor, because AppEventUtil provides only
     * static helper methods.
     */
    private AppEventUtil()
    {
    }

    /**
     * Helper method to process an AppEvent.
     *
     * @param pAppEventSupport the (logical) parent in the AppEvent chain of responsability
     * @param pAppEvent event that should be routed/processes, must not be null
     */
    public static void postAppEvent(final AppEventSupport pAppEventSupport, final AppEvent pAppEvent)
    {
        if (pAppEvent==null)
        {
            throw new IllegalArgumentException("appevent must not be null");
        }
        pAppEvent.forward();
        if (pAppEvent.isConsumed())
        {
            return;
        }
        if (pAppEventSupport!=null)
        {
            pAppEventSupport.postAppEvent(pAppEvent);
        }
    }
}
