package net.sf.cuf.xfer;

/**
 * The RequestDelegate interface describes a helper for the request dispatching.
 * Instead of the Request class the helper class is used for executing a request.
 * A class implementing RequestDelegate must be thread save, because a request
 * delegate may be used by more than one request and from different threads
 * at the same time.
 */
public interface RequestDelegate
{
    /**
     * Generates a response for the handed request.
     * @param pRequest the request, never null
     * @return a response for the request
     */
    public Response execute(Request pRequest);
}
