package net.sf.cuf.xfer;

/**
 * DefaultResponse is a default implementation for the Response interface.
 * In allmost all cases this implementation is suffient.
 */
public class DefaultResponse implements Response
{
    /** our error or result */
    private Object  mErrorOrResult;
    /** flag if we have an error or a result */
    private boolean mIsValid;
    /** flag if we where cancelled */
    private boolean mWasCancelled;

    /**
     * Creates an invalid response with a null error object that was not cancelled.
     */
    public DefaultResponse()
    {
        this(false);
    }

    /**
     * Creates an invalid response with a null error object.
     * @param pWasCancelled true if the request was cancelled
     */
    public DefaultResponse(final boolean pWasCancelled)
    {
        mIsValid      = false;
        mWasCancelled = pWasCancelled;
        mErrorOrResult= null;
    }

    public boolean isValid()
    {
        return mIsValid;
    }

    public boolean wasCancelled()
    {
        return mWasCancelled;
    }

    public synchronized void setError(final Object pError)
    {
        mErrorOrResult= pError;
        mIsValid      = false;
    }

    public Object getError()
    {
        if (mIsValid)
            return null;
        else
            return mErrorOrResult;
    }

    public synchronized void setResult(final Object pResponse)
    {
        mErrorOrResult= pResponse;
        mIsValid      = true;
    }

    public Object getResult()
    {
        if (mIsValid)
            return mErrorOrResult;
        else
            return null;
    }

    public boolean equals(final Object pOther)
    {
        if (!(pOther instanceof DefaultResponse))
            return false;

        DefaultResponse defaultResponse = (DefaultResponse) pOther;

        if (mIsValid != defaultResponse.mIsValid)
        {
            return false;
        }

        return !(mErrorOrResult != null ? !mErrorOrResult.equals(defaultResponse.mErrorOrResult) : defaultResponse.mErrorOrResult != null);

    }

    public int hashCode()
    {
        int result= 0;
        if (mIsValid)
            result= 1;
        result |= (mErrorOrResult != null ? mErrorOrResult.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[valid=");
        sb.append(mIsValid);
        sb.append(",errorOrResult=");
        sb.append(mErrorOrResult);
        sb.append(']');
        return sb.toString();
    }
}
