/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.singleapp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.sf.cuf.singleapp.ContactHandler;

public class StartupSocketCommunicator {
    private static final long MAGIC_NUMBER = 8920712192410910312L;
    private static final String OK_STRING = "OK";
    private static final String NOK_STRING_PREFIX = "NOK:";
    private String mApplicationId;
    private boolean mServerMode;
    private boolean mServerStopped;
    private boolean mServerStopRequested;
    private Thread mShutdownHook;
    private ServerCommunicatorSocketThread mServerSocketThread;
    private ServerSocket mServerSocket;
    private ContactHandler mContactHandler;
    private Throwable mException;
    private Serializable mClientResult;

    public StartupSocketCommunicator(String pApplicationId, int pPort, ContactHandler pContactHandler, Serializable pData) {
        if (pContactHandler == null) {
            throw new IllegalArgumentException("pContactHandler must not be null");
        }
        this.mApplicationId = pApplicationId;
        this.mContactHandler = pContactHandler;
        try {
            this.mServerSocket = new ServerSocket(pPort);
        }
        catch (IOException e) {
            this.mServerSocket = null;
        }
        if (this.mServerSocket == null) {
            this.runClientMode(pPort, pData);
        } else {
            this.initServerMode();
        }
    }

    private void runClientMode(int pPort, Serializable pData) {
        block10: {
            this.mServerMode = false;
            this.mServerStopRequested = true;
            this.mServerStopped = true;
            Socket clientSocket = null;
            ObjectOutputStream out = null;
            ObjectInputStream in = null;
            try {
                clientSocket = new Socket(InetAddress.getLocalHost().getHostAddress(), pPort);
                out = new ObjectOutputStream(clientSocket.getOutputStream());
                in = new ObjectInputStream(clientSocket.getInputStream());
                this.handleConversationForClient(out, in, pData);
                in.close();
                out.close();
                clientSocket.close();
            }
            catch (Throwable ex) {
                this.setException(ex);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (clientSocket == null || clientSocket.isClosed()) break block10;
                try {
                    clientSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    private void handleConversationForClient(ObjectOutputStream pOut, ObjectInputStream pIn, Serializable pData) throws IOException, ClassNotFoundException {
        pOut.writeLong(8920712192410910312L);
        pOut.flush();
        this.checkOkResponse(pIn);
        pOut.writeObject(this.mApplicationId);
        pOut.flush();
        this.checkOkResponse(pIn);
        pOut.writeObject(pData);
        pOut.flush();
        this.checkOkResponse(pIn);
        this.checkOkResponse(pIn);
        this.mClientResult = (Serializable)pIn.readObject();
    }

    private void checkOkResponse(ObjectInputStream pIn) throws IOException, ClassNotFoundException {
        Object obj = pIn.readObject();
        if (obj instanceof String && OK_STRING.equals(obj)) {
            return;
        }
        throw new RuntimeException("Error in communication to server: " + obj);
    }

    private void initServerMode() {
        this.mServerMode = true;
        this.mServerStopRequested = false;
        this.mServerStopped = false;
        this.mServerSocketThread = new ServerCommunicatorSocketThread();
        this.mServerSocketThread.start();
    }

    public synchronized boolean isServerMode() {
        return this.mServerMode;
    }

    public synchronized boolean isServerStopped() {
        return this.mServerStopped;
    }

    public synchronized Throwable getException() {
        return this.mException;
    }

    public Serializable getClientResult() {
        return this.mClientResult;
    }

    private synchronized void setException(Throwable pException) {
        this.mException = pException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        if (!this.mServerMode) {
            return;
        }
        StartupSocketCommunicator startupSocketCommunicator = this;
        synchronized (startupSocketCommunicator) {
            if (this.mServerStopped) {
                return;
            }
            if (this.mServerStopRequested) {
                return;
            }
            this.mServerStopRequested = true;
        }
        if (this.mShutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.mShutdownHook);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            this.mShutdownHook = null;
        }
        try {
            this.mServerSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void waitServerStopped() throws InterruptedException {
        this.stopServer();
        while (!this.isServerStopped()) {
            Thread.sleep(100L);
        }
    }

    private class ClientContactHandlerThread
    extends Thread {
        private Socket mSocket;

        private ClientContactHandlerThread(Socket pSocket) {
            this.setDaemon(true);
            this.mSocket = pSocket;
        }

        @Override
        public void run() {
            block10: {
                ObjectInputStream in = null;
                ObjectOutputStream out = null;
                try {
                    in = new ObjectInputStream(this.mSocket.getInputStream());
                    out = new ObjectOutputStream(this.mSocket.getOutputStream());
                    this.handleConversationForServer(in, out);
                    in.close();
                    out.close();
                    this.mSocket.close();
                }
                catch (Throwable ex) {
                    StartupSocketCommunicator.this.setException(ex);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (this.mSocket.isClosed()) break block10;
                    try {
                        this.mSocket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }

        private void handleConversationForServer(ObjectInputStream pIn, ObjectOutputStream pOut) throws IOException, ClassNotFoundException {
            Serializable result;
            long clientMagicNumber = pIn.readLong();
            if (clientMagicNumber != 8920712192410910312L) {
                pOut.writeObject("NOK:Magic Number does not match");
                pOut.flush();
                throw new RuntimeException("Client sent different magic number: got " + clientMagicNumber + " expected " + 8920712192410910312L);
            }
            pOut.writeObject(StartupSocketCommunicator.OK_STRING);
            pOut.flush();
            String clientAppId = (String)pIn.readObject();
            if (!StartupSocketCommunicator.this.mApplicationId.equals(clientAppId)) {
                pOut.writeObject("NOK:Application id does not match");
                pOut.flush();
                throw new RuntimeException("Client sent different application id: got " + clientAppId + " expected " + StartupSocketCommunicator.this.mApplicationId);
            }
            pOut.writeObject(StartupSocketCommunicator.OK_STRING);
            pOut.flush();
            Serializable data = (Serializable)pIn.readObject();
            pOut.writeObject(StartupSocketCommunicator.OK_STRING);
            pOut.flush();
            try {
                result = StartupSocketCommunicator.this.mContactHandler.handleContactFromOtherInstance(data);
            }
            catch (RuntimeException ex) {
                pOut.writeObject("NOK:Handler returned error: " + ex);
                pOut.flush();
                throw ex;
            }
            pOut.writeObject(StartupSocketCommunicator.OK_STRING);
            pOut.flush();
            pOut.writeObject(result);
            pOut.flush();
        }
    }

    private class ServerCommunicatorSocketThread
    extends Thread {
        private ServerCommunicatorSocketThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean stopRequested;
            try {
                StartupSocketCommunicator startupSocketCommunicator = StartupSocketCommunicator.this;
                synchronized (startupSocketCommunicator) {
                    stopRequested = StartupSocketCommunicator.this.mServerStopRequested;
                }
            }
            catch (Throwable throwable) {
                try {
                    StartupSocketCommunicator.this.mServerSocket.close();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                StartupSocketCommunicator startupSocketCommunicator = StartupSocketCommunicator.this;
                synchronized (startupSocketCommunicator) {
                    StartupSocketCommunicator.this.mServerStopped = true;
                    throw throwable;
                }
            }
            while (!stopRequested) {
                Socket socket;
                try {
                    socket = StartupSocketCommunicator.this.mServerSocket.accept();
                }
                catch (IOException e) {
                    StartupSocketCommunicator startupSocketCommunicator = StartupSocketCommunicator.this;
                    synchronized (startupSocketCommunicator) {
                        if (StartupSocketCommunicator.this.mServerStopRequested) {
                            // MONITOREXIT @DISABLED, blocks:[17, 22, 28, 30] lbl27 : MonitorExitStatement: MONITOREXIT : var4_7
                            try {
                                StartupSocketCommunicator.this.mServerSocket.close();
                            }
                            catch (Throwable ex) {
                                // empty catch block
                            }
                            StartupSocketCommunicator ex = StartupSocketCommunicator.this;
                            synchronized (ex) {
                                StartupSocketCommunicator.this.mServerStopped = true;
                                return;
                            }
                        }
                        StartupSocketCommunicator.this.setException(e);
                    }
                    try {
                        StartupSocketCommunicator.this.mServerSocket.close();
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                    StartupSocketCommunicator startupSocketCommunicator2 = StartupSocketCommunicator.this;
                    synchronized (startupSocketCommunicator2) {
                        StartupSocketCommunicator.this.mServerStopped = true;
                        return;
                    }
                }
                if (socket != null) {
                    new ClientContactHandlerThread(socket).start();
                }
                StartupSocketCommunicator startupSocketCommunicator = StartupSocketCommunicator.this;
                synchronized (startupSocketCommunicator) {
                    stopRequested = StartupSocketCommunicator.this.mServerStopRequested;
                }
            }
            try {
                StartupSocketCommunicator.this.mServerSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StartupSocketCommunicator startupSocketCommunicator = StartupSocketCommunicator.this;
            synchronized (startupSocketCommunicator) {
                StartupSocketCommunicator.this.mServerStopped = true;
                return;
            }
        }
    }
}

